/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.ide.DataManager;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenFileDescriptor
implements Navigatable {
    public static final DataKey<Editor> NAVIGATE_IN_EDITOR = DataKey.create("NAVIGATE_IN_EDITOR");
    @NotNull
    private final VirtualFile myFile;
    private final int myOffset;
    private final int myLine;
    private final int myColumn;
    private final RangeMarker myRangeMarker;
    private final Project myProject;

    public OpenFileDescriptor(Project project, @NotNull VirtualFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/OpenFileDescriptor.<init> must not be null");
        }
        this(project, file, -1, -1, offset);
    }

    public OpenFileDescriptor(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/OpenFileDescriptor.<init> must not be null");
        }
        this(psiElement.getProject(), psiElement.getContainingFile().getVirtualFile(), psiElement.getTextOffset());
    }

    public OpenFileDescriptor(Project project, @NotNull VirtualFile file, int line, int col) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/OpenFileDescriptor.<init> must not be null");
        }
        this(project, file, line, col, -1);
    }

    public OpenFileDescriptor(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/OpenFileDescriptor.<init> must not be null");
        }
        this(project, file, -1, -1, -1);
    }

    private OpenFileDescriptor(Project project, VirtualFile file, int line, int col, int offset) {
        Document document;
        this.myProject = project;
        this.myFile = file;
        this.myLine = line;
        this.myColumn = col;
        this.myOffset = offset;
        this.myRangeMarker = offset >= 0 ? ((document = FileDocumentManager.getInstance().getDocument(file)) != null && offset <= document.getTextLength() ? document.createRangeMarker(offset, offset) : null) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/OpenFileDescriptor.getFile must not return null");
        }
        return virtualFile;
    }

    public int getOffset() {
        return this.myRangeMarker != null && this.myRangeMarker.isValid() ? this.myRangeMarker.getStartOffset() : this.myOffset;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public void navigate(boolean requestFocus) {
        if (!this.canNavigate()) {
            throw new IllegalStateException("Navigation is not possible with null project");
        }
        if (this.navigateDirectory(requestFocus)) {
            return;
        }
        if (this.navigateInEditor(this.myProject, requestFocus)) {
            return;
        }
        this.navigateInProjectView();
    }

    private boolean navigateDirectory(boolean requestFocus) {
        PsiDirectory directory;
        if (this.myFile != null && this.myFile.isDirectory() && (directory = PsiManager.getInstance(this.myProject).findDirectory(this.myFile)) != null) {
            directory.navigate(requestFocus);
            return true;
        }
        return false;
    }

    private boolean navigateInEditor(Project project, boolean focusEditor) {
        FileType type = FileTypeManager.getInstance().getKnownFileTypeOrAssociate(this.myFile);
        if (type == null || this.myFile == null || !this.myFile.isValid()) {
            return false;
        }
        if (this.navigateInRequestedEditor()) {
            return true;
        }
        return this.navigateInAnyFileEditor(project, focusEditor);
    }

    private boolean navigateInRequestedEditor() {
        DataContext ctx = DataManager.getInstance().getDataContext();
        Editor e = NAVIGATE_IN_EDITOR.getData(ctx);
        if (e == null) {
            return false;
        }
        if (FileDocumentManager.getInstance().getFile(e.getDocument()) != this.myFile) {
            return false;
        }
        this.navigateIn(e);
        return true;
    }

    private boolean navigateInAnyFileEditor(Project project, boolean focusEditor) {
        List<FileEditor> editors = FileEditorManager.getInstance(project).openEditor(this, focusEditor);
        return !editors.isEmpty();
    }

    private void navigateInProjectView() {
        SelectInTarget selector = SelectInManager.getInstance(this.myProject).getTarget(SelectInManager.PROJECT);
        if (selector == null) {
            return;
        }
        selector.selectIn(new SelectInContext(){

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public Project getProject() {
                Project project = OpenFileDescriptor.this.myProject;
                if (project == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/OpenFileDescriptor$1.getProject must not return null");
                }
                return project;
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public VirtualFile getVirtualFile() {
                VirtualFile virtualFile = OpenFileDescriptor.this.myFile;
                if (virtualFile == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/OpenFileDescriptor$1.getVirtualFile must not return null");
                }
                return virtualFile;
            }

            @Nullable
            public Object getSelectorInFile() {
                return OpenFileDescriptor.this.myFile.isValid() ? PsiManager.getInstance(OpenFileDescriptor.this.myProject).findFile(OpenFileDescriptor.this.myFile) : null;
            }

            @Nullable
            public FileEditorProvider getFileEditorProvider() {
                return null;
            }
        }, true);
    }

    public void navigateIn(Editor e) {
        if (this.getOffset() >= 0) {
            e.getCaretModel().moveToOffset(Math.min(this.getOffset(), e.getDocument().getTextLength()));
        } else if (this.getLine() != -1 && this.getColumn() != -1) {
            LogicalPosition pos = new LogicalPosition(this.getLine(), this.getColumn());
            e.getCaretModel().moveToLogicalPosition(pos);
        } else {
            return;
        }
        e.getSelectionModel().removeSelection();
        this.scrollToCaret(e);
    }

    private void scrollToCaret(final Editor e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                e.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            }
        });
    }

    public boolean canNavigate() {
        return this.myProject != null;
    }

    public boolean canNavigateToSource() {
        return this.myProject != null;
    }

    public Project getProject() {
        return this.myProject;
    }
}

