/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDocumentManager {
    public static FileDocumentManager getInstance() {
        return ApplicationManager.getApplication().getComponent(FileDocumentManager.class);
    }

    public abstract Document getDocument(@NotNull VirtualFile var1);

    @Nullable
    public abstract Document getCachedDocument(@NotNull VirtualFile var1);

    public abstract VirtualFile getFile(@NotNull Document var1);

    public abstract void saveAllDocuments();

    public abstract void saveDocument(@NotNull Document var1);

    @NotNull
    public abstract Document[] getUnsavedDocuments();

    public abstract boolean isDocumentUnsaved(@NotNull Document var1);

    public abstract boolean isFileModified(@NotNull VirtualFile var1);

    public abstract void addFileDocumentSynchronizationVetoer(@NotNull FileDocumentSynchronizationVetoListener var1);

    public abstract void removeFileDocumentSynchronizationVetoer(@NotNull FileDocumentSynchronizationVetoListener var1);

    public abstract void addFileDocumentManagerListener(@NotNull FileDocumentManagerListener var1);

    public abstract void removeFileDocumentManagerListener(@NotNull FileDocumentManagerListener var1);

    public abstract void reloadFromDisk(@NotNull Document var1);

    @NotNull
    public abstract String getLineSeparator(@Nullable VirtualFile var1, @Nullable Project var2);

    public static boolean fileForDocumentCheckedOutSuccessfully(@NotNull Document document, Project project) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/FileDocumentManager.fileForDocumentCheckedOutSuccessfully must not be null");
        }
        if (project != null) {
            VirtualFile file = FileDocumentManager.getInstance().getFile(document);
            if (file != null) {
                ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(file);
                return !operationStatus.hasReadonlyFiles();
            }
            document.fireReadOnlyModificationAttempt();
            return false;
        }
        document.fireReadOnlyModificationAttempt();
        return false;
    }

    public abstract void reloadFiles(VirtualFile ... var1);
}

