/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;

public class FileElement {
    private final VirtualFile myFile;
    private final String myName;
    private Boolean myIsHidden;

    public FileElement(VirtualFile file, String name) {
        this.myFile = file;
        this.myName = name;
    }

    public int hashCode() {
        return this.myFile == null ? 0 : this.myFile.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof FileElement && ((FileElement)obj).myFile == this.myFile;
    }

    public final boolean isHidden() {
        if (this.myIsHidden == null) {
            this.myIsHidden = FileElement.isFileHidden(this.getFile());
        }
        return this.myIsHidden;
    }

    public final VirtualFile getFile() {
        return this.myFile;
    }

    public final String toString() {
        if (this.myName != null) {
            return this.myName;
        }
        return this.myFile.getName();
    }

    public final String getName() {
        return this.myName;
    }

    public static boolean isFileHidden(VirtualFile virtualFile) {
        if (virtualFile == null || !virtualFile.isValid()) {
            return false;
        }
        if (!virtualFile.isInLocalFileSystem()) {
            return false;
        }
        File file = new File(virtualFile.getPath().replace('/', File.separatorChar));
        return file.getParent() != null && file.isHidden();
    }

    public static boolean isArchive(VirtualFile file) {
        if (FileElement.isArchiveFileSystem(file) && file.getParent() == null) {
            return true;
        }
        return !file.isDirectory() && FileTypeManager.getInstance().getFileTypeByFile(file) == StdFileTypes.ARCHIVE && !FileElement.isArchiveFileSystem(file.getParent());
    }

    private static boolean isArchiveFileSystem(VirtualFile file) {
        return file.getFileSystem() instanceof JarFileSystem;
    }

    public boolean isArchive() {
        return FileElement.isArchive(this.getFile());
    }
}

