/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.util.IconUtil;
import com.intellij.util.Icons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChooserDescriptor
implements Cloneable {
    private final boolean myChooseFiles;
    private final boolean myChooseFolders;
    private final boolean myChooseJars;
    private final boolean myChooseJarsAsFiles;
    private final boolean myChooseJarContents;
    private final boolean myChooseMultiple;
    private String myTitle = UIBundle.message("file.chooser.default.title", new Object[0]);
    private String myDescription;
    private boolean myHideIgnored = true;
    private List<VirtualFile> myRoots = new ArrayList<VirtualFile>();
    private boolean myShowFileSystemRoots = true;
    private boolean myIsTreeRootVisible = false;
    private Module myContextModule = null;
    private String myNewFileTemplateText = null;
    private FileType myNewFileType = null;

    public FileChooserDescriptor(boolean chooseFiles, boolean chooseFolders, boolean chooseJars, boolean chooseJarsAsFiles, boolean chooseJarContents, boolean chooseMultiple) {
        this.myChooseFiles = chooseFiles;
        this.myChooseFolders = chooseFolders;
        this.myChooseJars = chooseJars;
        this.myChooseJarsAsFiles = chooseJarsAsFiles;
        this.myChooseJarContents = chooseJarContents;
        this.myChooseMultiple = chooseMultiple;
    }

    public final String getTitle() {
        return this.myTitle;
    }

    public final void setTitle(String title) {
        this.myTitle = title;
    }

    public boolean isShowFileSystemRoots() {
        return this.myShowFileSystemRoots;
    }

    public void setShowFileSystemRoots(boolean showFileSystemRoots) {
        this.myShowFileSystemRoots = showFileSystemRoots;
    }

    public final String getDescription() {
        return this.myDescription;
    }

    public final void setDescription(String description) {
        this.myDescription = description;
    }

    public final boolean isChooseJarContents() {
        return this.myChooseJarContents;
    }

    public boolean isChooseFiles() {
        return this.myChooseFiles;
    }

    public final boolean getChooseMultiple() {
        return this.myChooseMultiple;
    }

    public boolean isFileSelectable(VirtualFile file) {
        if (file.isDirectory() && this.myChooseFolders) {
            return true;
        }
        if (this.acceptAsJarFile(file)) {
            return true;
        }
        return this.acceptAsGeneralFile(file);
    }

    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
        if (!file.isDirectory() && (FileElement.isArchive(file) ? !this.myChooseJars && !this.myChooseJarContents : !this.myChooseFiles)) {
            return false;
        }
        if (this.isHideIgnored() && !showHiddenFiles && FileTypeManager.getInstance().isFileIgnored(file.getName())) {
            return false;
        }
        return showHiddenFiles || !FileElement.isFileHidden(file);
    }

    public Icon getOpenIcon(VirtualFile virtualFile) {
        if (virtualFile.isDirectory()) {
            return Icons.DIRECTORY_OPEN_ICON;
        }
        return IconUtil.getIcon(virtualFile, 2, null);
    }

    public Icon getClosedIcon(VirtualFile virtualFile) {
        if (virtualFile.isDirectory()) {
            return Icons.DIRECTORY_CLOSED_ICON;
        }
        return IconUtil.getIcon(virtualFile, 2, null);
    }

    public String getName(VirtualFile virtualFile) {
        return virtualFile.getPath();
    }

    @Nullable
    public String getComment(VirtualFile virtualFile) {
        return null;
    }

    public void validateSelectedFiles(VirtualFile[] files) throws Exception {
    }

    private boolean acceptAsGeneralFile(VirtualFile file) {
        if (FileElement.isArchive(file)) {
            return false;
        }
        return !file.isDirectory() && this.myChooseFiles;
    }

    private boolean acceptAsJarFile(VirtualFile file) {
        return this.myChooseJars && FileElement.isArchive(file);
    }

    public final VirtualFile getFileToSelect(VirtualFile file) {
        boolean isJar;
        if (file.isDirectory() && this.myChooseFolders) {
            return file;
        }
        boolean bl = isJar = FileTypeManager.getInstance().getFileTypeByFile(file) == StdFileTypes.ARCHIVE;
        if (!isJar) {
            return this.acceptAsGeneralFile(file) ? file : null;
        }
        if (this.myChooseJarsAsFiles) {
            return file;
        }
        if (!this.acceptAsJarFile(file)) {
            return null;
        }
        String path = file.getPath();
        return JarFileSystem.getInstance().findFileByPath(path + "!/");
    }

    public final void setHideIgnored(boolean hideIgnored) {
        this.myHideIgnored = hideIgnored;
    }

    public final List<VirtualFile> getRoots() {
        return this.myRoots;
    }

    public final void setRoot(VirtualFile root) {
        this.myRoots.clear();
        this.addRoot(root);
    }

    public void addRoot(VirtualFile root) {
        this.myRoots.add(root);
    }

    public boolean isTreeRootVisible() {
        return this.myIsTreeRootVisible;
    }

    public void setIsTreeRootVisible(boolean isTreeRootVisible) {
        this.myIsTreeRootVisible = isTreeRootVisible;
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isChooseFolders() {
        return this.myChooseFolders;
    }

    public boolean isChooseJars() {
        return this.myChooseJars;
    }

    public boolean isChooseJarsAsFiles() {
        return this.myChooseJarsAsFiles;
    }

    public boolean isChooseMultiple() {
        return this.myChooseMultiple;
    }

    public boolean isHideIgnored() {
        return this.myHideIgnored;
    }

    public Module getContextModule() {
        return this.myContextModule;
    }

    public void setContextModule(Module contextModule) {
        this.myContextModule = contextModule;
    }

    public String getNewFileTemplateText() {
        return this.myNewFileTemplateText;
    }

    public void setNewFileTemplateText(String newFileTemplateText) {
        this.myNewFileTemplateText = newFileTemplateText;
    }

    public FileType getNewFileType() {
        return this.myNewFileType;
    }

    public void setNewFileType(FileType newFileType) {
        this.myNewFileType = newFileType;
    }
}

