/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooser {
    private FileChooser() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static VirtualFile[] chooseFiles(Project project, FileChooserDescriptor descriptor) {
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles(project, descriptor, null);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileChooser/FileChooser.chooseFiles must not return null");
        }
        return virtualFileArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static VirtualFile[] chooseFiles(Component parent, FileChooserDescriptor descriptor) {
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles(parent, descriptor, null);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileChooser/FileChooser.chooseFiles must not return null");
        }
        return virtualFileArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static VirtualFile[] chooseFiles(Project project, FileChooserDescriptor descriptor, @Nullable VirtualFile toSelect) {
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project);
        VirtualFile[] virtualFileArray = chooser.choose(toSelect, project);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileChooser/FileChooser.chooseFiles must not return null");
        }
        return virtualFileArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static VirtualFile[] chooseFiles(Component parent, FileChooserDescriptor descriptor, @Nullable VirtualFile toSelect) {
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, parent);
        VirtualFile[] virtualFileArray = chooser.choose(toSelect, null);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileChooser/FileChooser.chooseFiles must not return null");
        }
        return virtualFileArray;
    }
}

