/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.awt.Color;
import org.jdom.Element;

public class TextAttributes
implements JDOMExternalizable,
Cloneable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.markup.TextAttributes");
    public static final TextAttributes ERASE_MARKER = new TextAttributes();
    private Externalizable myExternalizable = new Externalizable();

    public static TextAttributes merge(TextAttributes under, TextAttributes above) {
        if (under == null) {
            return above;
        }
        if (above == null) {
            return under;
        }
        TextAttributes attrs = under.clone();
        if (above.getBackgroundColor() != null) {
            attrs.setBackgroundColor(above.getBackgroundColor());
        }
        if (above.getForegroundColor() != null) {
            attrs.setForegroundColor(above.getForegroundColor());
        }
        attrs.setFontType(above.getFontType() | under.getFontType());
        if (above.getEffectColor() != null) {
            attrs.setEffectColor(above.getEffectColor());
            attrs.setEffectType(above.getEffectType());
        }
        return attrs;
    }

    public TextAttributes() {
    }

    public TextAttributes(Color foregroundColor, Color backgroundColor, Color effectColor, EffectType effectType, int fontType) {
        this.setForegroundColor(foregroundColor);
        this.setBackgroundColor(backgroundColor);
        this.setEffectColor(effectColor);
        this.setEffectType(effectType);
        this.setFontType(fontType);
    }

    public boolean isEmpty() {
        return this.getForegroundColor() == null && this.getBackgroundColor() == null && this.getEffectColor() == null && this.getFontType() == 0;
    }

    public Color getForegroundColor() {
        return this.myExternalizable.FOREGROUND;
    }

    public void setForegroundColor(Color color) {
        this.myExternalizable.FOREGROUND = color;
    }

    public Color getBackgroundColor() {
        return this.myExternalizable.BACKGROUND;
    }

    public void setBackgroundColor(Color color) {
        this.myExternalizable.BACKGROUND = color;
    }

    public Color getEffectColor() {
        return this.myExternalizable.EFFECT_COLOR;
    }

    public void setEffectColor(Color color) {
        this.myExternalizable.EFFECT_COLOR = color;
    }

    public Color getErrorStripeColor() {
        return this.myExternalizable.ERROR_STRIPE_COLOR;
    }

    public void setErrorStripeColor(Color color) {
        this.myExternalizable.ERROR_STRIPE_COLOR = color;
    }

    public EffectType getEffectType() {
        switch (this.myExternalizable.EFFECT_TYPE) {
            case 0: {
                return EffectType.BOXED;
            }
            case 1: {
                return EffectType.LINE_UNDERSCORE;
            }
            case 3: {
                return EffectType.STRIKEOUT;
            }
            case 2: {
                return EffectType.WAVE_UNDERSCORE;
            }
        }
        return null;
    }

    public void setEffectType(EffectType effectType) {
        this.myExternalizable.EFFECT_TYPE = effectType == EffectType.BOXED ? 0 : (effectType == EffectType.LINE_UNDERSCORE ? 1 : (effectType == EffectType.STRIKEOUT ? 3 : (effectType == EffectType.WAVE_UNDERSCORE ? 2 : -1)));
    }

    public int getFontType() {
        return this.myExternalizable.FONT_TYPE;
    }

    public void setFontType(int type) {
        if (type < 0 || type > 3) {
            LOG.error("Wrong font type: " + type);
            type = 0;
        }
        this.myExternalizable.FONT_TYPE = type;
    }

    public TextAttributes clone() {
        try {
            TextAttributes cloned = new TextAttributes();
            cloned.myExternalizable = (Externalizable)this.myExternalizable.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            LOG.error(e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextAttributes)) {
            return false;
        }
        TextAttributes textAttributes = (TextAttributes)obj;
        if (!Comparing.equal(textAttributes.getForegroundColor(), this.getForegroundColor())) {
            return false;
        }
        if (!Comparing.equal(textAttributes.getBackgroundColor(), this.getBackgroundColor())) {
            return false;
        }
        if (!Comparing.equal(textAttributes.getErrorStripeColor(), this.getErrorStripeColor())) {
            return false;
        }
        if (!Comparing.equal(textAttributes.getEffectColor(), this.getEffectColor())) {
            return false;
        }
        if (textAttributes.getEffectType() != this.getEffectType()) {
            return false;
        }
        return textAttributes.getFontType() == this.getFontType();
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getForegroundColor() != null) {
            hashCode += this.getForegroundColor().hashCode();
        }
        if (this.getBackgroundColor() != null) {
            hashCode += this.getBackgroundColor().hashCode();
        }
        if (this.getErrorStripeColor() != null) {
            hashCode += this.getErrorStripeColor().hashCode();
        }
        if (this.getEffectColor() != null) {
            hashCode += this.getEffectColor().hashCode();
        }
        return hashCode += this.getFontType();
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myExternalizable.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myExternalizable.writeExternal(element);
    }

    private static class Externalizable
    implements Cloneable,
    JDOMExternalizable {
        public Color FOREGROUND = null;
        public Color BACKGROUND = null;
        public int FONT_TYPE = 0;
        public Color EFFECT_COLOR = null;
        public int EFFECT_TYPE = 0;
        public Color ERROR_STRIPE_COLOR = null;
        private static final int EFFECT_BORDER = 0;
        private static final int EFFECT_LINE = 1;
        private static final int EFFECT_WAVE = 2;
        private static final int EFFECT_STRIKEOUT = 3;

        private Externalizable() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal(this, element);
            if (this.FONT_TYPE < 0 || this.FONT_TYPE > 3) {
                LOG.info("Wrong font type: " + this.FONT_TYPE);
                this.FONT_TYPE = 0;
            }
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal(this, element);
        }
    }
}

