/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ConcurrentHashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextAttributesKey
implements Comparable<TextAttributesKey>,
JDOMExternalizable {
    private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();
    public String myExternalName;
    public TextAttributes myDefaultAttributes = NULL_ATTRIBUTES;
    private static ConcurrentHashMap<String, TextAttributesKey> ourRegistry = new ConcurrentHashMap();

    private TextAttributesKey(String externalName) {
        this.myExternalName = externalName;
    }

    public TextAttributesKey() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static TextAttributesKey find(@NotNull @NonNls String externalName) {
        if (externalName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/colors/TextAttributesKey.find must not be null");
        }
        TextAttributesKey textAttributesKey = ourRegistry.cacheOrGet(externalName, new TextAttributesKey(externalName));
        if (textAttributesKey == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/colors/TextAttributesKey.find must not return null");
        }
        return textAttributesKey;
    }

    public String toString() {
        return this.myExternalName;
    }

    public String getExternalName() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(TextAttributesKey key) {
        return this.myExternalName.compareTo(key.myExternalName);
    }

    public TextAttributes getDefaultAttributes() {
        if (this.myDefaultAttributes == NULL_ATTRIBUTES) {
            this.myDefaultAttributes = null;
            EditorColorsManager manager = EditorColorsManager.getInstance();
            if (manager != null) {
                this.myDefaultAttributes = manager.getGlobalScheme().getAttributes(this);
            }
        }
        return this.myDefaultAttributes;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributes defaultAttributes) {
        if (externalName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/colors/TextAttributesKey.createTextAttributesKey must not be null");
        }
        TextAttributesKey key = TextAttributesKey.find(externalName);
        if (key.getDefaultAttributes() == null) {
            key.myDefaultAttributes = defaultAttributes;
        }
        TextAttributesKey textAttributesKey = key;
        if (textAttributesKey == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/colors/TextAttributesKey.createTextAttributesKey must not return null");
        }
        return textAttributesKey;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/colors/TextAttributesKey.createTextAttributesKey must not be null");
        }
        TextAttributesKey textAttributesKey = TextAttributesKey.find(externalName);
        if (textAttributesKey == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/colors/TextAttributesKey.createTextAttributesKey must not return null");
        }
        return textAttributesKey;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal(this, element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal(this, element);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextAttributesKey that = (TextAttributesKey)o;
        return this.myExternalName.equals(that.myExternalName);
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }
}

