/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColorKey
implements Comparable<ColorKey> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.colors.ColorKey");
    private static final Color NULL_COLOR = new Color(0, 0, 0);
    private final String myExternalName;
    private Color myDefaultColor = NULL_COLOR;
    private static Map<String, ColorKey> ourRegistry = new HashMap<String, ColorKey>();

    private ColorKey(String externalName) {
        this.myExternalName = externalName;
        if (ourRegistry.containsKey(this.myExternalName)) {
            LOG.error("Key " + this.myExternalName + " already registered.");
        } else {
            ourRegistry.put(this.myExternalName, this);
        }
    }

    public static ColorKey find(String externalName) {
        ColorKey key = ourRegistry.get(externalName);
        return key != null ? key : new ColorKey(externalName);
    }

    public String toString() {
        return this.myExternalName;
    }

    public String getExternalName() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(ColorKey key) {
        return this.myExternalName.compareTo(key.myExternalName);
    }

    public Color getDefaultColor() {
        if (this.myDefaultColor == NULL_COLOR) {
            this.myDefaultColor = null;
            EditorColorsManager manager = EditorColorsManager.getInstance();
            if (manager != null) {
                this.myDefaultColor = manager.getGlobalScheme().getColor(this);
            }
        }
        return this.myDefaultColor;
    }

    public static ColorKey createColorKey(@NonNls String externalName) {
        return ColorKey.find(externalName);
    }

    public static ColorKey createColorKey(@NonNls String externalName, Color defaultColor) {
        ColorKey key = ourRegistry.get(externalName);
        if (key == null) {
            key = ColorKey.find(externalName);
        }
        if (key.getDefaultColor() == null) {
            key.myDefaultColor = defaultColor;
        }
        return key;
    }
}

