/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;

public class TypedAction {
    private static final Object TYPING_COMMAND_GROUP = Key.create("Typing");
    private TypedActionHandler myHandler = new Handler();
    private static final PsiTreeChangeListener myCommitLogger = new PsiModificationTracker();

    public TypedActionHandler getHandler() {
        return this.myHandler;
    }

    public TypedActionHandler setupHandler(TypedActionHandler handler) {
        TypedActionHandler tmp = this.myHandler;
        this.myHandler = handler;
        return tmp;
    }

    public final void actionPerformed(final Editor editor, final char charTyped, final DataContext dataContext) {
        if (editor == null) {
            return;
        }
        Runnable command = new Runnable(){

            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Document doc = editor.getDocument();
                        doc.startGuardedBlockChecking();
                        try {
                            TypedAction.this.getHandler().execute(editor, charTyped, dataContext);
                        }
                        catch (ReadOnlyFragmentModificationException e) {
                            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler().handle(e);
                        }
                        finally {
                            doc.stopGuardedBlockChecking();
                        }
                    }
                });
            }
        };
        CommandProcessor.getInstance().executeCommand(DataKeys.PROJECT.getData(dataContext), command, "", TYPING_COMMAND_GROUP);
    }

    private static class PsiModificationTracker
    extends PsiTreeChangeAdapter {
        private PsiModificationTracker() {
        }

        public void beforeChildAddition(PsiTreeChangeEvent event) {
            this.logError();
        }

        public void beforeChildRemoval(PsiTreeChangeEvent event) {
            this.logError();
        }

        public void beforeChildReplacement(PsiTreeChangeEvent event) {
            this.logError();
        }

        public void beforeChildMovement(PsiTreeChangeEvent event) {
            this.logError();
        }

        public void beforeChildrenChange(PsiTreeChangeEvent event) {
            this.logError();
        }

        public void beforePropertyChange(PsiTreeChangeEvent event) {
            this.logError();
        }

        private void logError() {
        }
    }

    private static class Handler
    implements TypedActionHandler {
        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Editor editor, char charTyped, DataContext dataContext) {
            if (editor.isViewer()) {
                return;
            }
            Document doc = editor.getDocument();
            if (!doc.isWritable() && !FileDocumentManager.fileForDocumentCheckedOutSuccessfully(doc, DataKeys.PROJECT.getData(dataContext))) {
                return;
            }
            Project project = editor.getProject();
            doc.startGuardedBlockChecking();
            if (project != null) {
                PsiManager.getInstance(project).addPsiTreeChangeListener(myCommitLogger);
            }
            try {
                String str = String.valueOf(charTyped);
                CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message("typing.in.editor.command.name", new Object[0]));
                EditorModificationUtil.typeInStringAtCaretHonorBlockSelection(editor, str, true);
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler().handle(e);
            }
            finally {
                if (project != null) {
                    PsiManager.getInstance(project).removePsiTreeChangeListener(myCommitLogger);
                }
                doc.stopGuardedBlockChecking();
            }
        }
    }
}

