/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.MockDocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;

public abstract class EditorWriteActionHandler
extends EditorActionHandler {
    public final void execute(final Editor editor, final DataContext dataContext) {
        if (editor.isViewer()) {
            return;
        }
        if (!editor.getDocument().isWritable() && !FileDocumentManager.fileForDocumentCheckedOutSuccessfully(editor.getDocument(), DataKeys.PROJECT.getData(dataContext))) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                RangeMarker guard;
                SelectionModel selectionModel = editor.getSelectionModel();
                if (selectionModel.hasBlockSelection() && (guard = selectionModel.getBlockSelectionGuard()) != null) {
                    MockDocumentEvent evt = new MockDocumentEvent(editor.getDocument(), editor.getCaretModel().getOffset());
                    ReadOnlyFragmentModificationException e = new ReadOnlyFragmentModificationException(evt, guard);
                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler().handle(e);
                    return;
                }
                Document doc = editor.getDocument();
                doc.startGuardedBlockChecking();
                try {
                    EditorWriteActionHandler.this.executeWriteAction(editor, dataContext);
                }
                catch (ReadOnlyFragmentModificationException e) {
                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler().handle(e);
                }
                finally {
                    doc.stopGuardedBlockChecking();
                }
            }
        });
    }

    public abstract void executeWriteAction(Editor var1, DataContext var2);
}

