/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import org.jetbrains.annotations.Nullable;

public abstract class EditorAction
extends AnAction {
    private EditorActionHandler myHandler;

    public final EditorActionHandler getHandler() {
        return this.myHandler;
    }

    protected EditorAction(EditorActionHandler defaultHandler) {
        this.myHandler = defaultHandler;
        this.setEnabledInModalContext(true);
    }

    public final EditorActionHandler setupHandler(EditorActionHandler newHandler) {
        EditorActionHandler tmp = this.myHandler;
        this.myHandler = newHandler;
        return tmp;
    }

    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Editor editor = this.getEditor(dataContext);
        this.actionPerformed(editor, dataContext);
    }

    @Nullable
    protected Editor getEditor(DataContext dataContext) {
        return DataKeys.EDITOR.getData(dataContext);
    }

    public final void actionPerformed(final Editor editor, final DataContext dataContext) {
        if (editor == null) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        Runnable command = new Runnable(){

            public void run() {
                EditorAction.this.getHandler().execute(editor, EditorAction.getProjectAwareDataContext(editor, dataContext));
            }
        };
        String commandName = this.getTemplatePresentation().getText();
        if (commandName == null) {
            commandName = "";
        }
        commandProcessor.executeCommand(editor.getProject(), command, commandName, new Ref<Document>(editor.getDocument()));
    }

    public void update(Editor editor, Presentation presentation, DataContext dataContext) {
        presentation.setEnabled(this.getHandler().isEnabled(editor, dataContext));
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Editor editor = this.getEditor(dataContext);
        if (editor == null) {
            presentation.setEnabled(false);
        } else {
            this.update(editor, presentation, dataContext);
        }
    }

    private static DataContext getProjectAwareDataContext(final Editor editor, final DataContext original) {
        if (original.getData("project") == editor.getProject()) {
            return original;
        }
        return new DataContext(){

            public Object getData(String dataId) {
                if ("project".equals(dataId)) {
                    return editor.getProject();
                }
                return original.getData(dataId);
            }
        };
    }
}

