/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class SimpleDiffRequest
extends DiffRequest {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.SimpleDiffRequest");
    private final DiffContent[] myContents = new DiffContent[2];
    private final String[] myContentTitles = new String[2];
    private String myWindowTitle;
    private final HashSet myHints = new HashSet();

    public SimpleDiffRequest(Project project, String windowtitle) {
        super(project);
        this.myWindowTitle = windowtitle;
    }

    public DiffContent[] getContents() {
        return this.myContents;
    }

    public String[] getContentTitles() {
        return this.myContentTitles;
    }

    public String getWindowTitle() {
        return this.myWindowTitle;
    }

    public Collection getHints() {
        return Collections.unmodifiableCollection(this.myHints);
    }

    public void addHint(Object hint) {
        this.myHints.add(hint);
    }

    public void removeHint(Object hint) {
        this.myHints.remove(hint);
    }

    public void setContents(DiffContent content1, DiffContent content2) {
        this.myContents[0] = content1;
        this.myContents[1] = content2;
    }

    public void setContentTitles(String title1, String title2) {
        this.myContentTitles[0] = title1;
        this.myContentTitles[1] = title2;
    }

    public void setWindowTitle(String windowTitle) {
        this.myWindowTitle = windowTitle;
    }

    public static SimpleDiffRequest compareFiles(VirtualFile file1, VirtualFile file2, Project project, String title) {
        FileDiffRequest result = new FileDiffRequest(project, title);
        ((FileDiffRequest)result).myVirtualFiles[0] = file1;
        ((FileDiffRequest)result).myVirtualFiles[1] = file2;
        ((FileDiffRequest)result).myContentTitles[0] = DiffContentUtil.getTitle(file1);
        ((FileDiffRequest)result).myContentTitles[1] = DiffContentUtil.getTitle(file2);
        return result;
    }

    public static SimpleDiffRequest compareFiles(VirtualFile file1, VirtualFile file2, Project project) {
        return SimpleDiffRequest.compareFiles(file1, file2, project, DiffBundle.message("compare.file.vs.file.dialog.title", file1.getPresentableUrl(), file2.getPresentableUrl()));
    }

    private static class FileDiffRequest
    extends SimpleDiffRequest {
        private final String[] myContentTitles = new String[2];
        private final VirtualFile[] myVirtualFiles = new VirtualFile[2];

        public FileDiffRequest(Project project, String title) {
            super(project, title);
        }

        public DiffContent[] getContents() {
            return new DiffContent[]{DocumentContent.fromFile(this.getProject(), this.myVirtualFiles[0]), DocumentContent.fromFile(this.getProject(), this.myVirtualFiles[1])};
        }

        public String[] getContentTitles() {
            return this.myContentTitles;
        }
    }
}

