/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import java.util.ArrayList;

public class LineTokenizer {
    private final char[] myChars;
    private final String myText;
    private int myIndex = 0;
    private String myLineSeparator = null;

    public LineTokenizer(String text) {
        this.myChars = text.toCharArray();
        this.myText = text;
    }

    public String[] execute() {
        ArrayList<String> lines = new ArrayList<String>();
        while (this.notAtEnd()) {
            int begin = this.myIndex;
            this.skipToEOL();
            int endIndex = this.myIndex;
            boolean appendNewLine = false;
            if (this.notAtEnd() && this.isAtEOL()) {
                if (this.myChars[endIndex] == '\n') {
                    ++endIndex;
                } else {
                    appendNewLine = true;
                }
                this.skipEOL();
            }
            String line = this.myText.substring(begin, endIndex);
            if (appendNewLine) {
                line = line + "\n";
            }
            lines.add(line);
        }
        return lines.toArray(new String[lines.size()]);
    }

    private void skipEOL() {
        int eolStart = this.myIndex;
        boolean nFound = false;
        boolean rFound = false;
        while (this.notAtEnd()) {
            boolean r;
            boolean n = this.myChars[this.myIndex] == '\n';
            boolean bl = r = this.myChars[this.myIndex] == '\r';
            if (!n && !r || nFound && n || rFound && r) break;
            nFound |= n;
            rFound |= r;
            ++this.myIndex;
        }
        if (this.myLineSeparator == null) {
            this.myLineSeparator = new String(this.myChars, eolStart, this.myIndex - eolStart);
        }
    }

    public String getLineSeparator() {
        return this.myLineSeparator;
    }

    private void skipToEOL() {
        while (this.myIndex < this.myChars.length && this.myChars[this.myIndex] != '\r' && this.myChars[this.myIndex] != '\n') {
            ++this.myIndex;
        }
    }

    private boolean notAtEnd() {
        return this.myIndex < this.myChars.length;
    }

    private boolean isAtEOL() {
        return this.myChars[this.myIndex] == '\r' || this.myChars[this.myIndex] == '\n';
    }

    public static String concatLines(String[] lines) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            buffer.append(line);
        }
        return buffer.substring(0, buffer.length());
    }

    public static String correctLineSeparators(String text) {
        return LineTokenizer.concatLines(new LineTokenizer(text).execute());
    }
}

