/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

abstract class DocumentsSynchonizer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.DocumentsSynchonizer");
    private Document myOriginal = null;
    private Document myCopy = null;
    private final Project myProject;
    private boolean myDuringModification = false;
    private int myAssignedCount = 0;
    private final DocumentAdapter myOriginalListener = new DocumentAdapter(){

        public void documentChanged(DocumentEvent e) {
            if (DocumentsSynchonizer.this.myDuringModification) {
                return;
            }
            DocumentsSynchonizer.this.onOriginalChanged(e, DocumentsSynchonizer.this.getCopy());
        }
    };
    private final DocumentAdapter myCopyListener = new DocumentAdapter(){

        public void documentChanged(DocumentEvent e) {
            if (DocumentsSynchonizer.this.myDuringModification) {
                return;
            }
            DocumentsSynchonizer.this.onCopyChanged(e, DocumentsSynchonizer.this.getOriginal());
        }
    };
    private final PropertyChangeListener myROListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("writable".equals(evt.getPropertyName())) {
                DocumentsSynchonizer.this.getCopy().setReadOnly(!DocumentsSynchonizer.this.getOriginal().isWritable());
            }
        }
    };

    protected DocumentsSynchonizer(Project project) {
        this.myProject = project;
    }

    protected abstract void onCopyChanged(DocumentEvent var1, Document var2);

    protected abstract void onOriginalChanged(DocumentEvent var1, Document var2);

    protected abstract void beforeListenersAttached(Document var1, Document var2);

    protected abstract Document createOriginal();

    protected abstract Document createCopy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceString(final Document document, final int startOffset, final int endOffset, final String newText) {
        LOG.assertTrue(!this.myDuringModification);
        try {
            this.myDuringModification = true;
            CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                public void run() {
                    LOG.assertTrue(endOffset <= document.getTextLength());
                    document.replaceString(startOffset, endOffset, newText);
                }
            }, DiffBundle.message("save.merge.result.command.name", new Object[0]), null);
        }
        finally {
            this.myDuringModification = false;
        }
    }

    public void listenDocuments(boolean startListen) {
        int prevAssignedCount = this.myAssignedCount++;
        if (!startListen) {
            --this.myAssignedCount;
        }
        LOG.assertTrue(this.myAssignedCount >= 0);
        if (prevAssignedCount == 0 && this.myAssignedCount > 0) {
            this.startListen();
        }
        if (this.myAssignedCount == 0 && prevAssignedCount > 0) {
            this.stopListen();
        }
    }

    private void startListen() {
        Document original = this.getOriginal();
        Document copy = this.getCopy();
        if (original == null || copy == null) {
            return;
        }
        this.beforeListenersAttached(original, copy);
        original.addDocumentListener(this.myOriginalListener);
        copy.addDocumentListener(this.myCopyListener);
        original.addPropertyChangeListener(this.myROListener);
    }

    private void stopListen() {
        if (this.myOriginal != null) {
            this.myOriginal.removeDocumentListener(this.myOriginalListener);
            this.myOriginal.removePropertyChangeListener(this.myROListener);
        }
        if (this.myCopy != null) {
            this.myCopy.removeDocumentListener(this.myCopyListener);
        }
        this.myOriginal = null;
        this.myCopy = null;
    }

    public Document getOriginal() {
        if (this.myOriginal == null) {
            this.myOriginal = this.createOriginal();
        }
        return this.myOriginal;
    }

    public Document getCopy() {
        if (this.myCopy == null) {
            this.myCopy = this.createCopy();
        }
        return this.myCopy;
    }
}

