/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class DocumentContent
extends DiffContent {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.DocumentContent");
    private final Document myDocument;
    private final VirtualFile myFile;
    private final FileType myOverridenType;
    private Project myProject;

    public DocumentContent(Project project, Document document) {
        this(project, document, null);
    }

    public DocumentContent(Project project, Document document, FileType type) {
        this.myProject = project;
        LOG.assertTrue(document != null);
        this.myDocument = document;
        this.myFile = FileDocumentManager.getInstance().getFile(document);
        this.myOverridenType = type;
    }

    public DocumentContent(Document document) {
        this(null, document, null);
    }

    public DocumentContent(Document document, FileType type) {
        this(null, document, type);
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        VirtualFile file = this.getFile();
        if (file == null) {
            return null;
        }
        if (this.myProject == null) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, file, offset);
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public FileType getContentType() {
        return this.myOverridenType == null ? DiffContentUtil.getContentType(this.getFile()) : this.myOverridenType;
    }

    public byte[] getBytes() {
        return this.myDocument.getText().getBytes();
    }
}

