/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffToolbar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiffRequest {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.DiffData");
    private String myGroupKey = "DiffWindow";
    private final Project myProject;
    private ToolbarAddons myToolbarAddons = ToolbarAddons.NOTHING;
    @NonNls
    private static final String COMMON_DIFF_GROUP_KEY = "DiffWindow";
    private Factory<JComponent> myBottomComponentFactory = null;

    protected DiffRequest(Project project) {
        this.myProject = project;
    }

    public void setToolbarAddons(@NotNull ToolbarAddons toolbarAddons) {
        if (toolbarAddons == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/DiffRequest.setToolbarAddons must not be null");
        }
        this.myToolbarAddons = toolbarAddons;
    }

    public String getGroupKey() {
        return this.myGroupKey;
    }

    public void setGroupKey(@NonNls String groupKey) {
        this.myGroupKey = groupKey;
    }

    public Project getProject() {
        return this.myProject;
    }

    public abstract DiffContent[] getContents();

    public abstract String[] getContentTitles();

    public abstract String getWindowTitle();

    public void customizeToolbar(DiffToolbar toolbar) {
        this.myToolbarAddons.customize(toolbar);
    }

    public Collection getHints() {
        return Collections.emptySet();
    }

    @Nullable
    public JComponent getBottomComponent() {
        return this.myBottomComponentFactory == null ? null : this.myBottomComponentFactory.create();
    }

    public void setBottomComponentFactory(Factory<JComponent> factory) {
        this.myBottomComponentFactory = factory;
    }

    public static interface ToolbarAddons {
        public static final ToolbarAddons NOTHING = new ToolbarAddons(){

            public void customize(DiffToolbar toolbar) {
            }
        };
        public static final ToolbarAddons IDE_FRAME = new ToolbarAddons(){

            public void customize(DiffToolbar toolbar) {
                toolbar.removeActionById("$Copy");
                toolbar.removeActionById("Find");
            }
        };

        public void customize(DiffToolbar var1);
    }
}

