/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.IllegalCharsetNameException;
import org.jetbrains.annotations.Nullable;

public class BinaryContent
extends DiffContent {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.BinaryContent");
    private final FileType myFileType;
    private final byte[] myBytes;
    private final String myCharset;
    private Document myDocument = null;

    public BinaryContent(byte[] bytes, String charset, FileType fileType) {
        this.myFileType = fileType;
        this.myBytes = bytes;
        this.myCharset = fileType != null && fileType.isBinary() ? null : charset;
    }

    @Nullable
    public Document getDocument() {
        if (this.myDocument == null) {
            if (this.isBinary()) {
                return null;
            }
            String text = null;
            try {
                text = "System Default".equals(this.myCharset) ? new String(this.myBytes) : new String(this.myBytes, this.myCharset);
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (text == null) {
                text = new String(this.myBytes);
            }
            text = LineTokenizer.correctLineSeparators(text);
            this.myDocument = EditorFactory.getInstance().createDocument(text);
            this.myDocument.setReadOnly(true);
        }
        return this.myDocument;
    }

    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        return null;
    }

    public VirtualFile getFile() {
        return null;
    }

    public FileType getContentType() {
        return this.myFileType;
    }

    public byte[] getBytes() throws IOException {
        return this.myBytes;
    }

    public boolean isBinary() {
        return this.myCharset == null;
    }
}

