/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.util.ArrayUtil;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NonNls;

public abstract class Logger {
    public static Factory ourFactory = new Factory(){

        public Logger getLoggerInstance(String category) {
            return new DefaultLogger(category);
        }
    };

    public static void setFactory(Factory factory) {
        ourFactory = factory;
    }

    public static Logger getInstance(@NonNls String category) {
        return ourFactory.getLoggerInstance(category);
    }

    public abstract boolean isDebugEnabled();

    public abstract void debug(@NonNls String var1);

    public abstract void debug(Throwable var1);

    public abstract void debug(@NonNls String var1, Throwable var2);

    public void error(@NonNls String message) {
        this.error(message, new Throwable(), ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void error(@NonNls String message, String ... details) {
        this.error(message, new Throwable(), details);
    }

    public void error(@NonNls String message, Throwable e) {
        this.error(message, e, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void error(Throwable t) {
        this.error("", t, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void warn(@NonNls String message) {
        this.warn(message, null);
    }

    public void warn(Throwable t) {
        this.warn("", t);
    }

    public abstract void error(@NonNls String var1, Throwable var2, String ... var3);

    public abstract void info(@NonNls String var1);

    public abstract void info(@NonNls String var1, Throwable var2);

    public abstract void warn(@NonNls String var1, Throwable var2);

    public void info(Throwable t) {
        this.info("", t);
    }

    public boolean assertTrue(boolean value, @NonNls Object message) {
        if (!value) {
            StringBuilder resultMessage = new StringBuilder("Assertion failed");
            if (message != null) {
                resultMessage.append(": ").append(message);
            }
            this.error(resultMessage.toString(), new Throwable());
        }
        return value;
    }

    public boolean assertTrue(boolean value) {
        return value || this.assertTrue(value, "");
    }

    public abstract void setLevel(Level var1);

    public static interface Factory {
        public Logger getLoggerInstance(String var1);
    }
}

