/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NonNls;

public class IdeaLoggingEvent {
    private final String myMessage;
    private final Throwable myThrowable;

    public IdeaLoggingEvent(String message, Throwable throwable) {
        this.myMessage = message;
        this.myThrowable = throwable;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public Throwable getThrowable() {
        return this.myThrowable;
    }

    public String getThrowableText() {
        if (this.myThrowable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        this.myThrowable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.getBuffer().toString();
    }

    @NonNls
    public String toString() {
        return "IdeaLoggingEvent[message=" + this.myMessage + ", throwable=" + this.getThrowableText() + "]";
    }
}

