/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.deployment;

import com.intellij.openapi.compiler.CompilerBundle;
import gnu.trove.THashMap;
import java.util.Map;

public class PackagingMethod {
    public static final PackagingMethod[] EMPTY_ARRAY = new PackagingMethod[0];
    private final String myId;
    private final String myDescription;
    private static final Map<String, PackagingMethod> ourRegisteredMethods = new THashMap();
    public static final PackagingMethod DO_NOT_PACKAGE = new PackagingMethod("0", CompilerBundle.message("packaging.method.name.do.not.package", new Object[0]));
    public static final PackagingMethod COPY_FILES = new PackagingMethod("1", CompilerBundle.message("packaging.method.name.copy.files", new Object[0]));
    public static final PackagingMethod COPY_FILES_AND_LINK_VIA_MANIFEST = new PackagingMethod("2", CompilerBundle.message("packaging.method.name.copy.files.and.link.via.manifest", new Object[0]));
    public static final PackagingMethod COPY_CLASSES = new PackagingMethod("3", CompilerBundle.message("packaging.method.name.copy.classes", new Object[0]));
    public static final PackagingMethod INCLUDE_MODULE_IN_BUILD = new PackagingMethod("4", CompilerBundle.message("packaging.method.name.include.module.in.build", new Object[0]));
    public static final PackagingMethod JAR_AND_COPY_FILE = new PackagingMethod("5", CompilerBundle.message("packaging.method.name.jar.and.copy.file", new Object[0]));
    public static final PackagingMethod JAR_AND_COPY_FILE_AND_LINK_VIA_MANIFEST = new PackagingMethod("6", CompilerBundle.message("packaging.method.name.jar.copy.and.link.via.manifest", new Object[0]));

    private PackagingMethod(String id, String description) {
        this.myId = id;
        this.myDescription = description;
        ourRegisteredMethods.put(id, this);
    }

    public String getId() {
        return this.myId;
    }

    public static PackagingMethod getDeploymentMethodById(String id) {
        return ourRegisteredMethods.get(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackagingMethod)) {
            return false;
        }
        PackagingMethod method = (PackagingMethod)o;
        return this.myId.equals(method.myId);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    public String toString() {
        return CompilerBundle.message("packaging.method.presentation.with.description", this.myDescription);
    }
}

