/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.deployment;

import com.intellij.openapi.deployment.ContainerElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LibraryLink
extends ContainerElement {
    @NonNls
    public static final String MODULE_LEVEL = "module";

    public LibraryLink(Module parentModule) {
        super(parentModule);
    }

    @Nullable
    public abstract Library getLibrary();

    public abstract void addUrl(String var1);

    public abstract List<String> getUrls();

    public abstract List<String> getClassesRootUrls();

    public abstract boolean hasDirectoriesOnly();

    @Nullable
    public abstract String getName();

    public abstract String getLevel();

    @Nullable
    public static Library findLibrary(String libraryName, String libraryLevel, Project project) {
        if (libraryName == null) {
            return null;
        }
        LibraryTable table = LibraryLink.findTable(libraryLevel, project);
        if (table == null) {
            return null;
        }
        return table.getLibraryByName(libraryName);
    }

    @Nullable
    protected static LibraryTable findTable(String libraryLevel, Project project) {
        if (libraryLevel == null) {
            return null;
        }
        if ("application".equals(libraryLevel)) {
            return LibraryTablesRegistrar.getInstance().getLibraryTable();
        }
        return project == null ? null : LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(libraryLevel, project);
    }
}

