/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.deployment;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.make.BuildRecipe;
import com.intellij.openapi.compiler.make.PackagingFileFilter;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.deployment.ContainerElement;
import com.intellij.openapi.deployment.LibraryLink;
import com.intellij.openapi.deployment.ModuleLink;
import com.intellij.openapi.deployment.PackagingConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.descriptors.ConfigFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Set;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeploymentUtil {
    public static DeploymentUtil getInstance() {
        return ServiceManager.getService(DeploymentUtil.class);
    }

    public abstract boolean addModuleOutputContents(@NotNull CompileContext var1, @NotNull BuildRecipe var2, @NotNull Module var3, Module var4, @NonNls String var5, @NonNls String var6, @Nullable PackagingFileFilter var7);

    public abstract void addLibraryLink(@NotNull CompileContext var1, @NotNull BuildRecipe var2, @NotNull LibraryLink var3, @NotNull Module var4, String var5);

    public abstract void copyFile(@NotNull File var1, @NotNull File var2, @NotNull CompileContext var3, @Nullable Set<String> var4, @Nullable FileFilter var5) throws IOException;

    public abstract boolean addItemsRecursively(@NotNull BuildRecipe var1, @NotNull File var2, @NotNull Module var3, String var4, @Nullable PackagingFileFilter var5, String var6);

    public static void reportRecursiveCopying(CompileContext context, String sourceDirPath, String targetDirPath, String dirTitle, String additionalMessage) {
        String message = CompilerBundle.message("message.text.copy.dirTitle.dirPath.to.targetDirPath.will.lead.to.recursive.copying.additionalMessage", dirTitle, FileUtil.toSystemDependentName(sourceDirPath), FileUtil.toSystemDependentName(targetDirPath), additionalMessage);
        context.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
    }

    public static String trimForwardSlashes(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/deployment/DeploymentUtil.trimForwardSlashes must not be null");
        }
        while (path.length() != 0 && (path.charAt(0) == '/' || path.charAt(0) == File.separatorChar)) {
            path = path.substring(1);
        }
        return path;
    }

    public static String trimTrailingSlashes(@NotNull String path) {
        int l;
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/deployment/DeploymentUtil.trimTrailingSlashes must not be null");
        }
        for (l = path.length() - 1; l >= 0 && (path.charAt(l) == '/' || path.charAt(l) == File.separatorChar); --l) {
        }
        return path.substring(0, l + 1);
    }

    public abstract void reportDeploymentDescriptorDoesNotExists(ConfigFile var1, CompileContext var2, Module var3);

    @Nullable
    public abstract Manifest createManifest(@NotNull BuildRecipe var1);

    public abstract void addJavaModuleOutputs(@NotNull Module var1, @NotNull ModuleLink[] var2, @NotNull BuildRecipe var3, @NotNull CompileContext var4, String var5, String var6);

    @Deprecated
    public abstract void addJavaModuleOutputs(@NotNull Module var1, @NotNull ModuleLink[] var2, @NotNull BuildRecipe var3, @NotNull CompileContext var4, String var5);

    public static boolean checkFileExists(File file, CompileContext context) {
        if (!file.exists()) {
            context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message("compiler.message.text.file.does.not.exist", file), null, -1, -1);
            return false;
        }
        return true;
    }

    public static String concatPaths(String ... paths) {
        StringBuilder builder = new StringBuilder();
        for (String path : paths) {
            if (path.length() == 0) continue;
            int len = builder.length();
            if (len > 0 && builder.charAt(len - 1) != '/' && builder.charAt(len - 1) != File.separatorChar) {
                builder.append('/');
            }
            builder.append(len != 0 ? DeploymentUtil.trimForwardSlashes(path) : path);
        }
        return builder.toString();
    }

    public static String appendToPath(@NotNull String path, @NotNull String name) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/deployment/DeploymentUtil.appendToPath must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/deployment/DeploymentUtil.appendToPath must not be null");
        }
        if (!StringUtil.endsWithChar(path, '/') && !path.endsWith(File.separator)) {
            path = path + "/";
        }
        return path + DeploymentUtil.trimForwardSlashes(name);
    }

    public static File canonicalRelativePath(File file, String outputRelativePath) {
        return new File(PathUtil.getCanonicalPath(DeploymentUtil.appendToPath(file.getPath(), outputRelativePath)));
    }

    public abstract ModuleLink createModuleLink(Module var1, Module var2);

    public abstract LibraryLink createLibraryLink(Library var1, @NotNull Module var2);

    public abstract PackagingConfiguration createPackagingConfiguration(@NotNull Module var1);

    public abstract BuildRecipe createBuildRecipe();

    @Nullable
    public abstract ContainerElement findElementByOrderEntry(PackagingConfiguration var1, OrderEntry var2);

    @Nullable
    public abstract String getConfigFileErrorMessage(ConfigFile var1);

    @Nullable
    public static String getRelativePath(File baseDir, File file) {
        if (baseDir == null || file == null) {
            return null;
        }
        String basePath = baseDir.getAbsolutePath();
        String filePath = file.getAbsolutePath();
        return DeploymentUtil.getRelativePath(basePath, filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath) {
        int len;
        if (basePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/deployment/DeploymentUtil.getRelativePath must not be null");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/deployment/DeploymentUtil.getRelativePath must not be null");
        }
        if (basePath.equals(filePath)) {
            return "";
        }
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separatorChar;
        }
        int lastSeparatorIndex = 0;
        for (len = 0; len < filePath.length() && len < basePath.length() && filePath.charAt(len) == basePath.charAt(len); ++len) {
            if (basePath.charAt(len) != File.separatorChar) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = StringBuilderSpinAllocator.alloc();
        try {
            for (int i = len; i < basePath.length(); ++i) {
                if (basePath.charAt(i) != File.separatorChar) continue;
                relativePath.append("..");
                relativePath.append(File.separatorChar);
            }
            relativePath.append(filePath.substring(lastSeparatorIndex + 1));
            String string = relativePath.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose(relativePath);
        }
    }

    @Nullable
    public abstract File findUserSuppliedManifestFile(@NotNull BuildRecipe var1);

    public abstract void checkConfigFile(ConfigFile var1, CompileContext var2, Module var3);
}

