/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.deployment;

import com.intellij.openapi.deployment.PackagingMethod;
import com.intellij.openapi.deployment.ResolvableElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerElement
implements JDOMExternalizable,
Cloneable,
ResolvableElement {
    private final Map<String, String> myAttributes = new LinkedHashMap<String, String>();
    private Module myParentModule;
    @NonNls
    public static final String URI_ATTR = "URI";
    @NonNls
    public static final String PACKAGING_METHOD_ATTR = "method";
    @NonNls
    public static final String ELEMENT_ATTRIBUTE = "attribute";
    @NonNls
    public static final String ATTRIBUTE_NAME = "name";
    @NonNls
    public static final String ATTRIBUTE_VALUE = "value";

    protected ContainerElement(@Nullable Module parentModule) {
        this.myParentModule = parentModule;
    }

    public abstract String getPresentableName();

    public String getURI() {
        return this.getAttribute(URI_ATTR);
    }

    public void setURI(String uri) {
        this.setAttribute(URI_ATTR, uri);
    }

    public PackagingMethod getPackagingMethod() {
        String attribute = this.getAttribute(PACKAGING_METHOD_ATTR);
        return attribute == null ? PackagingMethod.DO_NOT_PACKAGE : PackagingMethod.getDeploymentMethodById(attribute);
    }

    public void setPackagingMethod(PackagingMethod method) {
        this.setAttribute(PACKAGING_METHOD_ATTR, method.getId());
    }

    public void setAttribute(String name, String value) {
        this.myAttributes.put(name, value);
    }

    public String getAttribute(String name) {
        return this.myAttributes.get(name);
    }

    @Nullable
    public Module getParentModule() {
        return this.myParentModule;
    }

    public void setParentModule(Module module) {
        this.myParentModule = module;
    }

    public void readExternal(Element element) throws InvalidDataException {
        List attrs = element.getChildren(ELEMENT_ATTRIBUTE);
        for (int i = 0; i < attrs.size(); ++i) {
            Element attribute = (Element)attrs.get(i);
            String name = attribute.getAttributeValue(ATTRIBUTE_NAME);
            String value = attribute.getAttributeValue(ATTRIBUTE_VALUE);
            this.setAttribute(name, value);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (String name : this.myAttributes.keySet()) {
            String value = this.getAttribute(name);
            Element attr = new Element(ELEMENT_ATTRIBUTE);
            attr.setAttribute(ATTRIBUTE_NAME, name);
            attr.setAttribute(ATTRIBUTE_VALUE, value == null ? "" : value);
            element.addContent(attr);
        }
    }

    public abstract boolean equalsIgnoreAttributes(ContainerElement var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerElement)) {
            return false;
        }
        ContainerElement otherElement = (ContainerElement)o;
        if (!this.equalsIgnoreAttributes(otherElement)) {
            return false;
        }
        return ((Object)this.myAttributes).equals(otherElement.myAttributes);
    }

    public int hashCode() {
        return 0;
    }

    public abstract String getDescription();

    public abstract String getDescriptionForPackagingMethod(PackagingMethod var1);

    public ContainerElement clone() {
        throw new UnsupportedOperationException();
    }
}

