/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.util.io.fs.IFile;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface StateStorage {
    public static final Topic<Listener> STORAGE_TOPIC = new Topic<Listener>("STORAGE_LISTENER", Listener.class, Topic.BroadcastDirection.TO_PARENT);

    @Nullable
    public <T> T getState(Object var1, String var2, Class<T> var3, @Nullable T var4) throws StateStorageException;

    public boolean hasState(Object var1, String var2, Class<?> var3) throws StateStorageException;

    @NotNull
    public ExternalizationSession startExternalization();

    @NotNull
    public SaveSession startSave(ExternalizationSession var1);

    public void finishSave(SaveSession var1);

    public void reload(Set<String> var1) throws StateStorageException;

    public static interface Listener {
        public void storageFileChanged(VirtualFileEvent var1, StateStorage var2);
    }

    public static class StateStorageException
    extends RuntimeException {
        public StateStorageException() {
        }

        public StateStorageException(String message) {
            super(message);
        }

        public StateStorageException(String message, Throwable cause) {
            super(message, cause);
        }

        public StateStorageException(Throwable cause) {
            super(cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SaveSession {
        public void save() throws StateStorageException;

        public Set<String> getUsedMacros();

        @Nullable
        public Set<String> analyzeExternalChanges(Set<Pair<VirtualFile, StateStorage>> var1);

        public Collection<IFile> getStorageFilesToSave() throws StateStorageException;

        public List<IFile> getAllStorageFiles();
    }

    public static interface ExternalizationSession {
        public void setState(Object var1, String var2, Object var3, @Nullable Storage var4) throws StateStorageException;
    }
}

