/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.options;

import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ExcludedEntriesConfiguration
implements JDOMExternalizable {
    @NonNls
    private static final String FILE = "file";
    @NonNls
    private static final String DIRECTORY = "directory";
    @NonNls
    private static final String URL = "url";
    @NonNls
    private static final String INCLUDE_SUBDIRECTORIES = "includeSubdirectories";
    private List<ExcludeEntryDescription> myExcludeEntryDescriptions = new ArrayList<ExcludeEntryDescription>();
    private ExcludeEntryDescription[] myCachedDescriptions = null;

    public synchronized ExcludeEntryDescription[] getExcludeEntryDescriptions() {
        if (this.myCachedDescriptions == null) {
            this.myCachedDescriptions = this.myExcludeEntryDescriptions.toArray(new ExcludeEntryDescription[this.myExcludeEntryDescriptions.size()]);
        }
        return this.myCachedDescriptions;
    }

    public synchronized void addExcludeEntryDescription(ExcludeEntryDescription description) {
        this.myExcludeEntryDescriptions.add(description);
        this.myCachedDescriptions = null;
    }

    public synchronized void removeAllExcludeEntryDescriptions() {
        this.myExcludeEntryDescriptions.clear();
        this.myCachedDescriptions = null;
    }

    public void readExternal(Element node) {
        for (Object o : node.getChildren()) {
            Element element = (Element)o;
            String url = element.getAttributeValue(URL);
            if (url == null) continue;
            if (FILE.equals(element.getName())) {
                ExcludeEntryDescription excludeEntryDescription = new ExcludeEntryDescription(url, false, true);
                this.addExcludeEntryDescription(excludeEntryDescription);
            }
            if (!DIRECTORY.equals(element.getName())) continue;
            boolean includeSubdirectories = Boolean.parseBoolean(element.getAttributeValue(INCLUDE_SUBDIRECTORIES));
            ExcludeEntryDescription excludeEntryDescription = new ExcludeEntryDescription(url, includeSubdirectories, false);
            this.addExcludeEntryDescription(excludeEntryDescription);
        }
    }

    public void writeExternal(Element element) {
        for (ExcludeEntryDescription description : this.getExcludeEntryDescriptions()) {
            Element entry;
            if (description.isFile()) {
                entry = new Element(FILE);
                entry.setAttribute(URL, description.getUrl());
                element.addContent(entry);
                continue;
            }
            entry = new Element(DIRECTORY);
            entry.setAttribute(URL, description.getUrl());
            entry.setAttribute(INCLUDE_SUBDIRECTORIES, Boolean.toString(description.isIncludeSubdirectories()));
            element.addContent(entry);
        }
    }

    public boolean isExcluded(VirtualFile virtualFile) {
        for (ExcludeEntryDescription entryDescription : this.getExcludeEntryDescriptions()) {
            VirtualFile descriptionFile = entryDescription.getVirtualFile();
            if (descriptionFile == null || !(entryDescription.isFile() ? descriptionFile.equals(virtualFile) : (entryDescription.isIncludeSubdirectories() ? VfsUtil.isAncestor(descriptionFile, virtualFile, false) : !virtualFile.isDirectory() && descriptionFile.equals(virtualFile.getParent())))) continue;
            return true;
        }
        return false;
    }
}

