/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.options;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PanelWithButtons;
import com.intellij.ui.RightAlignedLabelUI;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.Table;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ExcludedEntriesConfigurable
implements UnnamedConfigurable {
    private Project myProject;
    private ArrayList<ExcludeEntryDescription> myExcludeEntryDescriptions = new ArrayList();
    private FileChooserDescriptor myDescriptor;
    private ExcludedEntriesConfiguration myConfiguration;

    public ExcludedEntriesConfigurable(Project project, FileChooserDescriptor descriptor, ExcludedEntriesConfiguration configuration) {
        this.myDescriptor = descriptor;
        this.myConfiguration = configuration;
        this.myProject = project;
    }

    public void reset() {
        ExcludeEntryDescription[] descriptions = this.myConfiguration.getExcludeEntryDescriptions();
        this.myExcludeEntryDescriptions.clear();
        for (ExcludeEntryDescription description : descriptions) {
            this.myExcludeEntryDescriptions.add(description.copy());
        }
    }

    public void apply() {
        this.myConfiguration.removeAllExcludeEntryDescriptions();
        for (ExcludeEntryDescription description : this.myExcludeEntryDescriptions) {
            this.myConfiguration.addExcludeEntryDescription(description);
        }
    }

    public boolean isModified() {
        ExcludeEntryDescription[] excludeEntryDescriptions = this.myConfiguration.getExcludeEntryDescriptions();
        if (excludeEntryDescriptions.length != this.myExcludeEntryDescriptions.size()) {
            return true;
        }
        for (int i = 0; i < excludeEntryDescriptions.length; ++i) {
            ExcludeEntryDescription description = excludeEntryDescriptions[i];
            if (Comparing.equal(description, this.myExcludeEntryDescriptions.get(i))) continue;
            return true;
        }
        return false;
    }

    public JComponent createComponent() {
        return new ExcludedEntriesPanel();
    }

    public void disposeUIResources() {
    }

    private static class MyObjectRenderer
    extends DefaultTableCellRenderer {
        public MyObjectRenderer() {
            this.setUI(new RightAlignedLabelUI());
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof ExcludeEntryDescription) {
                ExcludeEntryDescription description = (ExcludeEntryDescription)value;
                this.setText(description.getPresentableUrl());
                if (!description.isValid()) {
                    this.setForeground(Color.RED);
                }
            }
            if (!isSelected) {
                this.setBackground(table.getBackground());
            }
            return component;
        }
    }

    private static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private JPanel myPanel = new JPanel();

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                if (isSelected) {
                    this.myPanel.setBackground(table.getSelectionBackground());
                } else {
                    this.myPanel.setBackground(table.getBackground());
                }
                return this.myPanel;
            }
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected((Boolean)value);
            return this;
        }
    }

    private class ExcludedEntriesPanel
    extends PanelWithButtons {
        private JButton myRemoveButton;
        private Table myExcludedTable;

        public ExcludedEntriesPanel() {
            this.initPanel();
        }

        protected String getLabelText() {
            return null;
        }

        protected JButton[] createButtons() {
            JButton addButton = new JButton(IdeBundle.message("button.add", new Object[0]));
            addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExcludedEntriesPanel.this.addPath(ExcludedEntriesConfigurable.this.myDescriptor);
                }
            });
            this.myRemoveButton = new JButton(IdeBundle.message("button.remove", new Object[0]));
            this.myRemoveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExcludedEntriesPanel.this.removePaths();
                }
            });
            this.myRemoveButton.setEnabled(false);
            this.myRemoveButton.getModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (ExcludedEntriesPanel.this.myExcludedTable.getSelectedRow() == -1) {
                        ExcludedEntriesPanel.this.myRemoveButton.setEnabled(false);
                    }
                }
            });
            return new JButton[]{addButton, this.myRemoveButton};
        }

        private void addPath(FileChooserDescriptor descriptor) {
            VirtualFile[] chosen;
            int selected = this.myExcludedTable.getSelectedRow() + 1;
            if (selected < 0) {
                selected = ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.size();
            }
            int savedSelected = selected;
            for (VirtualFile chosenFile : chosen = FileChooser.chooseFiles(ExcludedEntriesConfigurable.this.myProject, descriptor)) {
                if (this.isFileExcluded(chosenFile)) continue;
                ExcludeEntryDescription description = chosenFile.isDirectory() ? new ExcludeEntryDescription(chosenFile, true, false) : new ExcludeEntryDescription(chosenFile, false, true);
                ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.add(selected, description);
                ++selected;
            }
            if (selected > savedSelected) {
                AbstractTableModel model = (AbstractTableModel)this.myExcludedTable.getModel();
                model.fireTableRowsInserted(savedSelected, selected - 1);
                this.myExcludedTable.setRowSelectionInterval(savedSelected, selected - 1);
            }
        }

        private boolean isFileExcluded(VirtualFile file) {
            for (ExcludeEntryDescription description : ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions) {
                VirtualFile descriptionFile = description.getVirtualFile();
                if (descriptionFile == null || !file.equals(descriptionFile)) continue;
                return true;
            }
            return false;
        }

        private void removePaths() {
            TableCellEditor editor;
            int[] selected = this.myExcludedTable.getSelectedRows();
            if (selected == null || selected.length <= 0) {
                return;
            }
            if (this.myExcludedTable.isEditing() && (editor = this.myExcludedTable.getCellEditor()) != null) {
                editor.stopCellEditing();
            }
            AbstractTableModel model = (AbstractTableModel)this.myExcludedTable.getModel();
            Arrays.sort(selected);
            int indexToSelect = selected[selected.length - 1];
            int removedCount = 0;
            for (int indexToRemove : selected) {
                int row = indexToRemove - removedCount;
                ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.remove(row);
                model.fireTableRowsDeleted(row, row);
                ++removedCount;
            }
            if (indexToSelect >= ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.size()) {
                indexToSelect = ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.size() - 1;
            }
            if (indexToSelect >= 0) {
                this.myExcludedTable.setRowSelectionInterval(indexToSelect, indexToSelect);
            }
            this.myExcludedTable.requestFocus();
        }

        protected JComponent createMainComponent() {
            final String[] names = new String[]{CompilerBundle.message("exclude.from.compile.table.path.column.name", new Object[0]), CompilerBundle.message("exclude.from.compile.table.recursively.column.name", new Object[0])};
            AbstractTableModel dataModel = new AbstractTableModel(){

                public int getColumnCount() {
                    return names.length;
                }

                public int getRowCount() {
                    return ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.size();
                }

                public Object getValueAt(int row, int col) {
                    ExcludeEntryDescription description = (ExcludeEntryDescription)ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.get(row);
                    if (col == 0) {
                        return description;
                    }
                    if (col == 1) {
                        if (!description.isFile()) {
                            return description.isIncludeSubdirectories() ? Boolean.TRUE : Boolean.FALSE;
                        }
                        return null;
                    }
                    return null;
                }

                public String getColumnName(int column) {
                    return names[column];
                }

                public Class getColumnClass(int c) {
                    if (c == 0) {
                        return Object.class;
                    }
                    if (c == 1) {
                        return Boolean.class;
                    }
                    return null;
                }

                public boolean isCellEditable(int row, int col) {
                    if (col == 1) {
                        ExcludeEntryDescription description = (ExcludeEntryDescription)ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.get(row);
                        return !description.isFile();
                    }
                    return false;
                }

                public void setValueAt(Object aValue, int row, int col) {
                    ExcludeEntryDescription description = (ExcludeEntryDescription)ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.get(row);
                    description.setIncludeSubdirectories(aValue.equals(Boolean.TRUE));
                }
            };
            this.myExcludedTable = new Table(dataModel);
            this.myExcludedTable.setPreferredScrollableViewportSize(new Dimension(300, this.myExcludedTable.getRowHeight() * 6));
            this.myExcludedTable.setDefaultRenderer(Boolean.class, new BooleanRenderer());
            this.myExcludedTable.setDefaultRenderer(Object.class, new MyObjectRenderer());
            this.myExcludedTable.getColumn(names[0]).setPreferredWidth(350);
            this.myExcludedTable.getColumn(names[1]).setPreferredWidth(140);
            this.myExcludedTable.getSelectionModel().setSelectionMode(2);
            this.myExcludedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    ExcludedEntriesPanel.this.myRemoveButton.setEnabled(ExcludedEntriesPanel.this.myExcludedTable.getSelectedRow() >= 0);
                }
            });
            TableCellEditor editor = this.myExcludedTable.getDefaultEditor(String.class);
            if (editor instanceof DefaultCellEditor) {
                ((DefaultCellEditor)editor).setClickCountToStart(1);
            }
            return ScrollPaneFactory.createScrollPane(this.myExcludedTable);
        }
    }
}

