/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.options;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;

public class ExcludeEntryDescription {
    private boolean myIsFile = true;
    private boolean myIncludeSubdirectories;
    private VirtualFilePointer myFilePointer;

    public ExcludeEntryDescription(VirtualFile virtualFile, boolean includeSubdirectories, boolean isFile) {
        this.myFilePointer = VirtualFilePointerManager.getInstance().create(virtualFile, null);
        this.myIncludeSubdirectories = includeSubdirectories;
        this.myIsFile = isFile;
    }

    public ExcludeEntryDescription(String url, boolean includeSubdirectories, boolean isFile) {
        this.myFilePointer = VirtualFilePointerManager.getInstance().create(url, null);
        this.myIncludeSubdirectories = includeSubdirectories;
        this.myIsFile = isFile;
    }

    public ExcludeEntryDescription copy() {
        return new ExcludeEntryDescription(this.getUrl(), this.myIncludeSubdirectories, this.myIsFile);
    }

    public boolean isFile() {
        return this.myIsFile;
    }

    public String getUrl() {
        return this.myFilePointer.getUrl();
    }

    public String getPresentableUrl() {
        return this.myFilePointer.getPresentableUrl();
    }

    public boolean isIncludeSubdirectories() {
        return this.myIncludeSubdirectories;
    }

    public void setIncludeSubdirectories(boolean includeSubdirectories) {
        this.myIncludeSubdirectories = includeSubdirectories;
    }

    public VirtualFile getVirtualFile() {
        return this.myFilePointer.getFile();
    }

    public boolean isValid() {
        return this.myFilePointer.isValid();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExcludeEntryDescription)) {
            return false;
        }
        ExcludeEntryDescription entryDescription = (ExcludeEntryDescription)obj;
        if (entryDescription.myIsFile != this.myIsFile) {
            return false;
        }
        if (entryDescription.myIncludeSubdirectories != this.myIncludeSubdirectories) {
            return false;
        }
        return Comparing.equal(entryDescription.getUrl(), this.getUrl());
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }
}

