/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.make;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.make.BuildParticipant;
import com.intellij.openapi.compiler.make.BuildRecipe;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.CustomConfigFile;
import java.io.File;

public abstract class BuildParticipantBase
extends BuildParticipant {
    private final Module myModule;

    protected BuildParticipantBase(Module module) {
        this.myModule = module;
    }

    public Module getModule() {
        return this.myModule;
    }

    public void buildStarted(final CompileContext context) {
        new ReadAction(){

            protected void run(Result result) {
                ConfigFile[] descriptors;
                for (ConfigFile descriptor : descriptors = BuildParticipantBase.this.getDeploymentDescriptors()) {
                    DeploymentUtil.getInstance().checkConfigFile(descriptor, context, BuildParticipantBase.this.myModule);
                }
            }
        }.execute();
    }

    protected void registerDescriptorCopyingInstructions(final BuildRecipe instructions, CompileContext context) {
        final ConfigFile[] deploymentDescriptors = this.getDeploymentDescriptors();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            public void run() {
                CustomConfigFile[] customDescriptors;
                for (ConfigFile descriptor : deploymentDescriptors) {
                    VirtualFile virtualFile = descriptor.getVirtualFile();
                    if (virtualFile == null) continue;
                    File file = VfsUtil.virtualToIoFile(virtualFile);
                    instructions.addFileCopyInstruction(file, false, BuildParticipantBase.this.myModule, descriptor.getMetaData().getDirectoryPath() + "/" + virtualFile.getName(), null);
                }
                for (CustomConfigFile descriptor : customDescriptors = BuildParticipantBase.this.getCustomDescriptors()) {
                    String url = descriptor.getUrl();
                    VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(url);
                    if (virtualFile == null) continue;
                    File file = VfsUtil.virtualToIoFile(virtualFile);
                    instructions.addFileCopyInstruction(file, false, BuildParticipantBase.this.myModule, descriptor.getOutputDirectoryPath() + "/" + virtualFile.getName(), null);
                }
            }
        });
    }

    protected CustomConfigFile[] getCustomDescriptors() {
        return CustomConfigFile.EMPTY_ARRAY;
    }

    protected abstract ConfigFile[] getDeploymentDescriptors();
}

