/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class CompilerPaths {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.compiler.CompilerPaths");
    private static volatile String ourSystemPath;

    public static File getGeneratedDataDirectory(Project project, Compiler compiler) {
        File dir = new File(CompilerPaths.getGeneratedDataDirectory(project), compiler.getDescription().replaceAll("\\s+", "_"));
        dir.mkdirs();
        return dir;
    }

    public static File getGeneratedDataDirectory(Project project) {
        File dir = new File(CompilerPaths.getCompilerSystemDirectory(project), ".generated");
        dir.mkdirs();
        return dir;
    }

    public static File getCacheStoreDirectory(Project project) {
        File cacheStoreDirectory = new File(CompilerPaths.getCompilerSystemDirectory(project), ".dependency-info");
        cacheStoreDirectory.mkdirs();
        return cacheStoreDirectory;
    }

    public static File getCompilerSystemDirectory(Project project) {
        String projectDirName = project.getName() + "." + project.getLocationHash();
        String systemPath = ourSystemPath != null ? ourSystemPath : (ourSystemPath = PathUtil.getCanonicalPath(PathManager.getSystemPath()));
        File compilerSystemDir = new File(systemPath, "/compiler/" + projectDirName);
        compilerSystemDir.mkdirs();
        return compilerSystemDir;
    }

    @Nullable
    public static VirtualFile getModuleOutputDirectory(Module module, boolean forTestClasses) {
        VirtualFile path;
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
        VirtualFile outPath = forTestClasses ? ((path = moduleRootManager.getCompilerOutputPathForTests()) != null ? path : moduleRootManager.getCompilerOutputPath()) : moduleRootManager.getCompilerOutputPath();
        if (outPath == null) {
            return null;
        }
        if (!outPath.isValid()) {
            LOG.info("Requested output path for module " + module.getName() + " is not valid");
            return null;
        }
        return outPath;
    }

    @Nullable
    public static String getModuleOutputPath(Module module, boolean forTestClasses) {
        String url;
        final ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
        Application application = ApplicationManager.getApplication();
        String outPathUrl = forTestClasses ? (application.isDispatchThread() ? ((url = moduleRootManager.getCompilerOutputPathForTestsUrl()) != null ? url : moduleRootManager.getCompilerOutputPathUrl()) : application.runReadAction(new Computable<String>(){

            @Override
            public String compute() {
                String url = moduleRootManager.getCompilerOutputPathForTestsUrl();
                return url != null ? url : moduleRootManager.getCompilerOutputPathUrl();
            }
        })) : (application.isDispatchThread() ? moduleRootManager.getCompilerOutputPathUrl() : application.runReadAction(new Computable<String>(){

            @Override
            public String compute() {
                return moduleRootManager.getCompilerOutputPathUrl();
            }
        }));
        if (outPathUrl != null) {
            return VirtualFileManager.extractPath(outPathUrl);
        }
        return null;
    }
}

