/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

public abstract class UndoManager {
    public static UndoManager getInstance(Project project) {
        return project.getComponent(UndoManager.class);
    }

    public static UndoManager getGlobalInstance() {
        return ApplicationManager.getApplication().getComponent(UndoManager.class);
    }

    public abstract void undoableActionPerformed(UndoableAction var1);

    public abstract boolean isUndoInProgress();

    public abstract boolean isRedoInProgress();

    public abstract void undo(@Nullable FileEditor var1);

    public abstract void redo(@Nullable FileEditor var1);

    public abstract boolean isUndoAvailable(@Nullable FileEditor var1);

    public abstract boolean isRedoAvailable(@Nullable FileEditor var1);

    public abstract void clearUndoRedoQueue(VirtualFile var1);

    public abstract void clearUndoRedoQueue(FileEditor var1);

    public abstract void clearUndoRedoQueue(Document var1);

    public abstract void dropHistory();

    public abstract void markCommandAsNonUndoable(@Nullable VirtualFile var1);

    public abstract void markDocumentForUndo(PsiFile var1);
}

