/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;

public class DocumentReferenceByVirtualFile
extends DocumentReference {
    private VirtualFile myFile;
    private String myUrl = null;

    public DocumentReferenceByVirtualFile(VirtualFile file) {
        this.myFile = file;
    }

    public void beforeFileDeletion(VirtualFile file) {
        if (this.myFile != file) {
            return;
        }
        if (!this.myFile.isValid()) {
            return;
        }
        this.myUrl = file.getUrl();
    }

    protected String getUrl() {
        if (this.myFile.isValid()) {
            return this.myFile.getUrl();
        }
        return this.myUrl;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public Document getDocument() {
        if (!this.myFile.isValid()) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(this.myFile);
    }
}

