/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceByVirtualFile;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;

public class DocumentReferenceByDocument
extends DocumentReference {
    private Document myDocument;

    private DocumentReferenceByDocument(Document document) {
        this.myDocument = document;
    }

    public VirtualFile getFile() {
        return FileDocumentManager.getInstance().getFile(this.myDocument);
    }

    public Document getDocument() {
        return this.myDocument;
    }

    protected String getUrl() {
        VirtualFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getUrl();
    }

    public void beforeFileDeletion(VirtualFile file) {
    }

    public static DocumentReference createDocumentReference(Document document) {
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file != null) {
            return new DocumentReferenceByVirtualFile(file);
        }
        return new DocumentReferenceByDocument(document);
    }
}

