/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;

public abstract class DocumentReference {
    public static final DocumentReference[] EMPTY_ARRAY = new DocumentReference[0];

    public int hashCode() {
        VirtualFile file = this.getFile();
        return file != null ? file.hashCode() : this.getDocument().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DocumentReference)) {
            return false;
        }
        VirtualFile file1 = this.getFile();
        VirtualFile file2 = ((DocumentReference)object).getFile();
        if (file1 != null) {
            return file1.equals(file2);
        }
        if (file2 != null) {
            return file2.equals(file1);
        }
        return this.getDocument().equals(((DocumentReference)object).getDocument());
    }

    public abstract VirtualFile getFile();

    public abstract Document getDocument();

    public abstract void beforeFileDeletion(VirtualFile var1);

    protected abstract String getUrl();

    public boolean equalsByUrl(String url) {
        VirtualFile file = this.getFile();
        if (file == null) {
            return false;
        }
        if (file.isValid()) {
            return false;
        }
        String url1 = this.getUrl();
        if (url1 == null || url == null) {
            return false;
        }
        if (SystemInfo.isFileSystemCaseSensitive) {
            return url.equals(url1);
        }
        return url.compareToIgnoreCase(url1) == 0;
    }

    public String toString() {
        return this.getUrl();
    }
}

