/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command;

import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WriteCommandAction<T>
extends BaseActionRunnable<T> {
    private final String myName;
    private final String myGroupID;
    private final Project myProject;
    private final PsiFile[] myPsiFiles;

    protected WriteCommandAction(Project project, PsiFile ... files) {
        this(project, "Undefined", files);
    }

    protected WriteCommandAction(Project project, String commandName, PsiFile ... files) {
        this(project, commandName, (String)null, files);
    }

    protected WriteCommandAction(Project project, String name, String groupID, PsiFile ... files) {
        this.myName = name;
        this.myGroupID = groupID;
        this.myProject = project;
        this.myPsiFiles = files;
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final String getCommandName() {
        return this.myName;
    }

    public String getGroupID() {
        return this.myGroupID;
    }

    @Override
    public RunResult<T> execute() {
        final RunResult result = new RunResult(this);
        try {
            if (EventQueue.isDispatchThread()) {
                this.performWriteCommandAction(result);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        WriteCommandAction.this.performWriteCommandAction(result);
                    }
                });
            }
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new Error(e);
        }
        return result;
    }

    public static boolean ensureFilesWritable(@NotNull Project project, @NotNull Collection<PsiFile> psiFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/command/WriteCommandAction.ensureFilesWritable must not be null");
        }
        if (psiFiles == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/command/WriteCommandAction.ensureFilesWritable must not be null");
        }
        if (!psiFiles.isEmpty()) {
            SmartList<VirtualFile> list = new SmartList<VirtualFile>();
            for (PsiFile psiFile : psiFiles) {
                VirtualFile virtualFile;
                if (psiFile == null || (virtualFile = psiFile.getVirtualFile()) == null) continue;
                list.add(virtualFile);
            }
            if (!list.isEmpty() && ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(list.toArray(new VirtualFile[list.size()])).hasReadonlyFiles()) {
                return false;
            }
        }
        return true;
    }

    private void performWriteCommandAction(RunResult<T> result) {
        if (!WriteCommandAction.ensureFilesWritable(this.myProject, this.myPsiFiles == null ? Collections.emptyList() : Arrays.asList(this.myPsiFiles))) {
            return;
        }
        final RunResult[] results = new RunResult[]{result};
        CommandProcessor.getInstance().executeCommand(this.getProject(), new Runnable(){

            public void run() {
                WriteCommandAction.this.getApplication().runWriteAction(new Runnable(){

                    public void run() {
                        results[0].run();
                        results[0] = null;
                    }
                });
            }
        }, this.getCommandName(), this.getGroupID(), this.getUndoConfirmationPolicy());
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION;
    }

    protected <T> RunResult<T> executeCommand(RunResult<T> result) {
        final RunResult[] results = new RunResult[]{result};
        CommandProcessor.getInstance().executeCommand(this.getProject(), new Runnable(){

            public void run() {
                results[0].run();
                results[0] = null;
            }
        }, this.getCommandName(), this.getGroupID(), this.getUndoConfirmationPolicy());
        return result;
    }

    public static abstract class Simple
    extends WriteCommandAction {
        protected Simple(Project project, PsiFile ... files) {
            super(project, files);
        }

        protected Simple(Project project, String commandName, PsiFile ... files) {
            super(project, commandName, files);
        }

        protected Simple(Project project, String name, String groupID, PsiFile ... files) {
            super(project, name, groupID, files);
        }

        protected void run(Result result) throws Throwable {
            this.run();
        }

        protected abstract void run() throws Throwable;
    }
}

