/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunResult<T>
extends Result<T> {
    private BaseActionRunnable<T> myActionRunnable;
    protected Throwable myThrowable;

    protected RunResult() {
    }

    public RunResult(BaseActionRunnable<T> action) {
        this.myActionRunnable = action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult<T> run() {
        try {
            this.myActionRunnable.run(this);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable throwable) {
            this.myThrowable = throwable;
            if (!this.myActionRunnable.isSilentExecution()) {
                if (this.myThrowable instanceof Error) {
                    throw (Error)this.myThrowable;
                }
                if (this.myThrowable instanceof RuntimeException) {
                    throw (RuntimeException)this.myThrowable;
                }
                throw new Error(this.myThrowable);
            }
        }
        finally {
            this.myActionRunnable = null;
        }
        return this;
    }

    public T getResultObject() {
        return (T)this.myResult;
    }

    public RunResult logException(Logger logger) {
        if (this.hasException()) {
            logger.error(this.myThrowable);
        }
        return this;
    }

    public void throwException() throws Throwable {
        if (this.hasException()) {
            throw this.myThrowable;
        }
    }

    public boolean hasException() {
        return this.myThrowable != null;
    }

    public Throwable getThrowable() {
        return this.myThrowable;
    }

    public void setThrowable(Throwable throwable) {
        this.myThrowable = throwable;
    }
}

