/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PathManager {
    @NonNls
    private static final String PROPERTIES_FILE = "idea.properties.file";
    @NonNls
    private static final String IDEA_PROPERTIES = "idea.properties";
    @NonNls
    private static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    @NonNls
    private static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    @NonNls
    private static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    @NonNls
    private static final String PROPERTY_HOME_PATH = "idea.home.path";
    @NonNls
    private static String ourHomePath;
    @NonNls
    private static String ourSystemPath;
    @NonNls
    private static String ourConfigPath;
    @NonNls
    private static String ourPluginsPath;
    @NonNls
    private static String ourPreinstalledPluginsPath;
    @NonNls
    private static final String FILE = "file";
    @NonNls
    private static final String JAR = "jar";
    @NonNls
    private static final String JAR_DELIMITER = "!";
    @NonNls
    private static final String PROTOCOL_DELIMITER = ":";
    @NonNls
    public static final String DEFAULT_OPTIONS_FILE_NAME = "other";
    @NonNls
    private static final String LIB_FOLDER = "lib";
    @NonNls
    public static final String PLUGINS_DIRECTORY = "plugins";
    @NonNls
    private static final String BIN_FOLDER = "bin";
    @NonNls
    private static final String OPTIONS_FOLDER = "options";
    private static final FileFilter BIN_FOLDER_FILE_FILTER;
    private static final FileFilter PROPERTIES_FILE_FILTER;

    public static String getHomePath() {
        if (ourHomePath != null) {
            return ourHomePath;
        }
        if (System.getProperty(PROPERTY_HOME_PATH) != null) {
            ourHomePath = PathManager.getAbsolutePath(System.getProperty(PROPERTY_HOME_PATH));
        } else {
            Class<PathManager> aClass = PathManager.class;
            String rootPath = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
            if (rootPath != null) {
                String parent;
                File root = new File(rootPath).getAbsoluteFile();
                do {
                    parent = root.getParent();
                    assert (parent != null) : "No parent found for " + root + "; " + "bin" + " folder with " + "idea.properties" + " file not found";
                } while ((root = new File(parent).getAbsoluteFile()) != null && !PathManager.isIdeaHome(root));
                ourHomePath = root != null ? root.getAbsolutePath() : null;
            }
        }
        try {
            if (!SystemInfo.isFileSystemCaseSensitive) {
                ourHomePath = ourHomePath == null ? null : new File(ourHomePath).getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ourHomePath;
    }

    private static boolean isIdeaHome(File root) {
        File[] files = root.listFiles(BIN_FOLDER_FILE_FILTER);
        if (files != null && files.length > 0) {
            for (File binFolder : files) {
                File[] binFolderContents = binFolder.listFiles(PROPERTIES_FILE_FILTER);
                if (binFolderContents == null || binFolderContents.length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String getLibPath() {
        return PathManager.getHomePath() + File.separator + LIB_FOLDER;
    }

    private static String trimPathQuotes(String path) {
        if (path == null || path.length() < 3) {
            return path;
        }
        if (StringUtil.startsWithChar(path, '\"') && StringUtil.endsWithChar(path, '\"')) {
            return path.substring(1, path.length() - 1);
        }
        return path;
    }

    public static String getSystemPath() {
        if (ourSystemPath != null) {
            return ourSystemPath;
        }
        ourSystemPath = System.getProperty(PROPERTY_SYSTEM_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_SYSTEM_PATH))) : PathManager.getHomePath() + File.separator + "system";
        try {
            File file = new File(ourSystemPath);
            file.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ourSystemPath;
    }

    public static void ensureConfigFolderExists(boolean userInteractionAllowed, boolean createIfNotExists) {
        PathManager.getConfigPathWithoutDialog();
        File file = new File(ourConfigPath);
        if (createIfNotExists && !file.exists()) {
            file.mkdirs();
            if (userInteractionAllowed) {
                try {
                    Class<?> helper = Class.forName("com.intellij.openapi.application.ConfigImportHelper");
                    Method helperMethod = helper.getMethod("importConfigsTo", String.class);
                    helperMethod.invoke(null, ourConfigPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static String getConfigPath(boolean createIfNotExists) {
        PathManager.ensureConfigFolderExists(false, createIfNotExists);
        return ourConfigPath;
    }

    public static String getConfigPath() {
        return PathManager.getConfigPath(true);
    }

    private static String getConfigPathWithoutDialog() {
        if (ourConfigPath != null) {
            return ourConfigPath;
        }
        ourConfigPath = System.getProperty(PROPERTY_CONFIG_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_CONFIG_PATH))) : PathManager.getHomePath() + File.separator + "config";
        return ourConfigPath;
    }

    @NonNls
    public static String getHelpURL() {
        return "jar:file:///" + PathManager.getHelpJarPath() + "!/idea";
    }

    @NonNls
    private static String getHelpJarPath() {
        return PathManager.getHomePath() + File.separator + "help" + File.separator + "ideahelp.jar";
    }

    public static File getHelpJarFile() {
        return new File(PathManager.getHelpJarPath());
    }

    public static String getBinPath() {
        return PathManager.getHomePath() + File.separator + BIN_FOLDER;
    }

    public static String getOptionsPath() {
        return PathManager.getConfigPath() + File.separator + OPTIONS_FOLDER;
    }

    public static String getOptionsPathWithoutDialog() {
        return PathManager.getConfigPathWithoutDialog() + File.separator + OPTIONS_FOLDER;
    }

    public static String getPreinstalledPluginsPath() {
        if (ourPreinstalledPluginsPath == null) {
            ourPreinstalledPluginsPath = PathManager.getHomePath() + File.separatorChar + PLUGINS_DIRECTORY;
        }
        return ourPreinstalledPluginsPath;
    }

    public static String getPluginsPath() {
        if (ourPluginsPath == null) {
            ourPluginsPath = System.getProperty(PROPERTY_PLUGINS_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_PLUGINS_PATH))) : PathManager.getConfigPath() + File.separatorChar + PLUGINS_DIRECTORY;
        }
        return ourPluginsPath;
    }

    private static String getAbsolutePath(String path) {
        File file;
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = SystemProperties.getUserHome() + path.substring(1);
        }
        if (!(file = new File(path)).exists()) {
            return path;
        }
        file = file.getAbsoluteFile();
        return file.getAbsolutePath();
    }

    @NonNls
    public static File getOptionsFile(NamedJDOMExternalizable externalizable) {
        return new File(PathManager.getOptionsPath() + File.separatorChar + externalizable.getExternalFileName() + ".xml");
    }

    @NonNls
    public static File getOptionsFile(@NonNls String fileName) {
        return new File(PathManager.getOptionsPath() + File.separatorChar + fileName + ".xml");
    }

    @Nullable
    public static String getResourceRoot(Class context, @NonNls String path) {
        URL url = context.getResource(path);
        if (url == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        if (url == null) {
            return null;
        }
        return PathManager.extractRoot(url, path);
    }

    @NonNls
    private static String extractRoot(URL resourceURL, String resourcePath) {
        String archivePath;
        String fullPath;
        int delimiter;
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            System.err.println("precondition failed: " + resourcePath);
            return null;
        }
        String protocol = resourceURL.getProtocol();
        String resultPath = null;
        if (FILE.equals(protocol)) {
            String testResourcePath;
            String path = resourceURL.getFile();
            String testPath = path.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if (JAR.equals(protocol) && (delimiter = (fullPath = resourceURL.getFile()).indexOf(JAR_DELIMITER)) >= 0 && (archivePath = fullPath.substring(0, delimiter)).startsWith("file:")) {
            resultPath = archivePath.substring(FILE.length() + PROTOCOL_DELIMITER.length());
        }
        if (resultPath == null) {
            System.err.println("cannot extract: " + resultPath + " from " + resourceURL);
            return null;
        }
        resultPath = StringUtil.trimEnd(resultPath, File.separator);
        resultPath = StringUtil.replace(resultPath, "%20", " ");
        resultPath = StringUtil.replace(resultPath, "%23", "#");
        return resultPath;
    }

    @NonNls
    public static File getDefaultOptionsFile() {
        return new File(PathManager.getOptionsPath(), "other.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties() {
        File propFile;
        String propFilePath = System.getProperty(PROPERTIES_FILE);
        if (!(!StringUtil.isEmptyOrSpaces(propFilePath) && new File(propFilePath).exists() || !StringUtil.isEmptyOrSpaces(propFilePath = SystemProperties.getUserHome() + File.separator + IDEA_PROPERTIES) && new File(propFilePath).exists())) {
            propFilePath = PathManager.getBinPath() + File.separator + IDEA_PROPERTIES;
        }
        if ((propFile = new File(propFilePath)).exists()) {
            InputStream fis = null;
            try {
                fis = new BufferedInputStream(new FileInputStream(propFile));
                PropertyResourceBundle bundle = new PropertyResourceBundle(fis);
                Enumeration<String> keys = bundle.getKeys();
                Properties sysProperties = System.getProperties();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    String value = PathManager.substitueVars(bundle.getString(key));
                    if (sysProperties.getProperty(key, null) != null) continue;
                    sysProperties.setProperty(key, value);
                }
            }
            catch (IOException e) {
                System.out.println("Problem reading from property file: " + propFilePath);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String substitueVars(String s) {
        String ideaHomePath = PathManager.getHomePath();
        return PathManager.substituteVars(s, ideaHomePath);
    }

    public static String substituteVars(String s, String ideaHomePath) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("..")) {
            s = ideaHomePath + File.separatorChar + BIN_FOLDER + File.separatorChar + s;
        }
        s = StringUtil.replace(s, "${idea.home}", ideaHomePath);
        Properties props = System.getProperties();
        Set<Object> keys = props.keySet();
        for (Object key1 : keys) {
            String key = (String)key1;
            String value = props.getProperty(key);
            s = StringUtil.replace(s, "${" + key + "}", value);
        }
        return s;
    }

    static {
        BIN_FOLDER_FILE_FILTER = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && PathManager.BIN_FOLDER.equalsIgnoreCase(pathname.getName());
            }
        };
        PROPERTIES_FILE_FILTER = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && PathManager.IDEA_PROPERTIES.equalsIgnoreCase(pathname.getName());
            }
        };
    }
}

