/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ApplicationNamesInfo {
    @NonNls
    public static final String COMPONENT_NAME = "ApplicationInfo";
    private static ApplicationNamesInfo ourInstance;
    private String myProductName;
    private String myFullProductName;
    private String myLowercaseProductName;
    @NonNls
    private static final String ELEMENT_NAMES = "names";
    @NonNls
    private static final String ATTRIBUTE_PRODUCT = "product";
    @NonNls
    private static final String ATTRIBUTE_FULLNAME = "fullname";

    public static ApplicationNamesInfo getInstance() {
        if (ourInstance == null) {
            ourInstance = new ApplicationNamesInfo();
        }
        return ourInstance;
    }

    private ApplicationNamesInfo() {
        try {
            Document doc = JDOMUtil.loadDocument(ApplicationNamesInfo.class.getResourceAsStream("/idea/ApplicationInfo.xml"));
            this.readInfo(doc.getRootElement());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readInfo(Element rootElement) {
        Element names = rootElement.getChild(ELEMENT_NAMES);
        this.myProductName = names.getAttributeValue(ATTRIBUTE_PRODUCT);
        this.myFullProductName = names.getAttributeValue(ATTRIBUTE_FULLNAME);
        this.myLowercaseProductName = StringUtil.capitalize(this.myProductName.toLowerCase());
    }

    public String getProductName() {
        return this.myProductName;
    }

    public String getFullProductName() {
        return this.myFullProductName;
    }

    public String getLowercaseProductName() {
        return this.myLowercaseProductName;
    }
}

