/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class ComboBoxAction
extends AnAction
implements CustomComponentAction {
    private static final Icon ARROW_ICON = IconLoader.getIcon("/general/comboArrow.png");

    protected ComboBoxAction() {
    }

    public void actionPerformed(AnActionEvent e) {
    }

    public JComponent createCustomComponent(Presentation presentation) {
        JPanel panel = new JPanel(new GridBagLayout());
        ComboBoxButton button = new ComboBoxButton(presentation);
        panel.add((Component)button, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 0, 3), 0, 0));
        return panel;
    }

    @NotNull
    protected abstract DefaultActionGroup createPopupActionGroup(JComponent var1);

    protected class ComboBoxButton
    extends JButton {
        private Presentation myPresentation;
        private boolean myForcePressed = false;
        private PropertyChangeListener myButtonSynchronizer;

        public ComboBoxButton(Presentation presentation) {
            this.myPresentation = presentation;
            this.setModel(new MyButtonModel());
            this.setHorizontalAlignment(2);
            this.setFocusable(false);
            Insets margins = this.getMargin();
            this.setMargin(new Insets(margins.top, 2, margins.bottom, 2));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!ComboBoxButton.this.myForcePressed) {
                        ComboBoxButton.this.showPopup();
                    }
                }
            });
            this.putClientProperty("Quaqua.Button.style", "placard");
        }

        public void showPopup() {
            DefaultActionGroup group = ComboBoxAction.this.createPopupActionGroup(this);
            this.myForcePressed = true;
            this.repaint();
            Runnable onDispose = new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ComboBoxButton.this.myForcePressed = false;
                        }
                    });
                    ComboBoxButton.this.repaint();
                }
            };
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, group, DataManager.getInstance().getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, onDispose, 30);
            popup.showUnderneathOf(this);
        }

        public void removeNotify() {
            if (this.myButtonSynchronizer != null) {
                this.myPresentation.removePropertyChangeListener(this.myButtonSynchronizer);
                this.myButtonSynchronizer = null;
            }
            super.removeNotify();
        }

        public void addNotify() {
            super.addNotify();
            if (this.myButtonSynchronizer == null) {
                this.myButtonSynchronizer = new MyButtonSynchronizer();
                this.myPresentation.addPropertyChangeListener(this.myButtonSynchronizer);
            }
            this.initButton();
        }

        private void initButton() {
            this.setIcon(this.myPresentation.getIcon());
            this.setEnabled(this.myPresentation.isEnabled());
            this.setText(this.myPresentation.getText());
            this.updateTooltipText(this.myPresentation.getDescription());
            this.updateButtonSize();
        }

        private void updateTooltipText(String description) {
            String tooltip = AnAction.createTooltipText(description, ComboBoxAction.this);
            this.setToolTipText(tooltip.length() > 0 ? tooltip : null);
        }

        public void updateUI() {
            super.updateUI();
            if (UIUtil.isMotifLookAndFeel()) {
                this.setBorder(BorderFactory.createEtchedBorder());
            } else {
                this.setBorder(UIUtil.getButtonBorder());
            }
        }

        public final void paint(Graphics g) {
            super.paint(g);
            Dimension size = this.getSize();
            String text = this.getText();
            boolean isEmpty = this.getIcon() == null && (text == null || text.trim().length() == 0);
            int x = isEmpty ? (size.width - ARROW_ICON.getIconWidth()) / 2 : size.width - ARROW_ICON.getIconWidth() - 2;
            ARROW_ICON.paintIcon(null, g, x, (size.height - ARROW_ICON.getIconHeight()) / 2);
        }

        protected void updateButtonSize() {
            String text = this.getText();
            int width = (text == null || text.trim().length() == 0) && this.getIcon() == null ? ARROW_ICON.getIconWidth() + 10 : this.getUI().getPreferredSize((JComponent)this).width + ARROW_ICON.getIconWidth() + 2;
            this.setPreferredSize(new Dimension(width, 21));
        }

        private class MyButtonSynchronizer
        implements PropertyChangeListener {
            private MyButtonSynchronizer() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("text".equals(propertyName)) {
                    ComboBoxButton.this.setText((String)evt.getNewValue());
                    ComboBoxButton.this.updateButtonSize();
                } else if ("description".equals(propertyName)) {
                    ComboBoxButton.this.updateTooltipText((String)evt.getNewValue());
                } else if ("icon".equals(propertyName)) {
                    ComboBoxButton.this.setIcon((Icon)evt.getNewValue());
                    ComboBoxButton.this.updateButtonSize();
                } else if ("enabled".equals(propertyName)) {
                    ComboBoxButton.this.setEnabled((Boolean)evt.getNewValue());
                }
            }
        }

        protected class MyButtonModel
        extends DefaultButtonModel {
            protected MyButtonModel() {
            }

            public boolean isPressed() {
                return ComboBoxButton.this.myForcePressed || super.isPressed();
            }

            public boolean isArmed() {
                return ComboBoxButton.this.myForcePressed || super.isArmed();
            }
        }
    }
}

