/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultActionGroup
extends ActionGroup {
    private ArrayList<AnAction> mySortedChildren = new ArrayList();
    private ArrayList<Pair<AnAction, Constraints>> myPairs = new ArrayList();

    public DefaultActionGroup() {
        this(null, false);
    }

    public DefaultActionGroup(String shortName, boolean popup) {
        super(shortName, popup);
    }

    public final void add(@NotNull AnAction action, @NotNull ActionManager actionManager) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        if (actionManager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        this.add(action, new Constraints(Anchor.LAST, null), actionManager);
    }

    public final void add(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        this.add(action, new Constraints(Anchor.LAST, null));
    }

    public final void addSeparator() {
        this.add(Separator.getInstance());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        if (constraint == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        this.add(action, constraint, ActionManager.getInstance());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        if (constraint == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        if (actionManager == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        if (!(action instanceof Separator)) {
            if (this.mySortedChildren.contains(action)) {
                throw new IllegalArgumentException("cannot add an action twice");
            }
            for (Pair<AnAction, Constraints> pair : this.myPairs) {
                if (!action.equals(pair.first)) continue;
                throw new IllegalArgumentException("cannot add an action twice");
            }
        }
        constraint = (Constraints)constraint.clone();
        if (constraint.myAnchor == Anchor.FIRST) {
            this.mySortedChildren.add(0, action);
        } else if (constraint.myAnchor == Anchor.LAST) {
            this.mySortedChildren.add(action);
        } else if (this.addToSortedList(action, constraint, actionManager)) {
            this.actionAdded(action, actionManager);
        } else {
            this.myPairs.add(new Pair<AnAction, Constraints>(action, constraint));
        }
    }

    private void actionAdded(AnAction addedAction, ActionManager actionManager) {
        String addedActionId = addedAction instanceof ActionStub ? ((ActionStub)addedAction).getId() : actionManager.getId(addedAction);
        if (addedActionId == null) {
            return;
        }
        block0: while (this.myPairs.size() > 0) {
            for (int i = 0; i < this.myPairs.size(); ++i) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i);
                if (!this.addToSortedList((AnAction)pair.first, (Constraints)pair.second, actionManager)) continue;
                this.myPairs.remove(i);
                continue block0;
            }
        }
    }

    private boolean addToSortedList(AnAction action, Constraints constraint, ActionManager actionManager) {
        int index = DefaultActionGroup.findIndex(constraint.myRelativeToActionId, this.mySortedChildren, actionManager);
        if (index == -1) {
            return false;
        }
        if (constraint.myAnchor == Anchor.BEFORE) {
            this.mySortedChildren.add(index, action);
        } else {
            this.mySortedChildren.add(index + 1, action);
        }
        return true;
    }

    private static int findIndex(String actionId, ArrayList<AnAction> actions, ActionManager actionManager) {
        for (int i = 0; i < actions.size(); ++i) {
            String id;
            AnAction action = actions.get(i);
            if (!(action instanceof ActionStub ? ((ActionStub)action).getId().equals(actionId) : (id = actionManager.getId(action)) != null && id.equals(actionId))) continue;
            return i;
        }
        return -1;
    }

    public final void remove(AnAction action) {
        if (!this.mySortedChildren.remove(action)) {
            for (int i = 0; i < this.myPairs.size(); ++i) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i);
                if (!((AnAction)pair.first).equals(action)) continue;
                this.myPairs.remove(i);
                break;
            }
        }
    }

    public final void removeAll() {
        this.mySortedChildren.clear();
        this.myPairs.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public final AnAction[] getChildren(@Nullable AnActionEvent e) {
        int i;
        int sortedSize = this.mySortedChildren.size();
        AnAction[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i = 0; i < sortedSize; ++i) {
            children[i] = this.mySortedChildren.get(i);
        }
        for (i = 0; i < this.myPairs.size(); ++i) {
            children[i + sortedSize] = (AnAction)this.myPairs.get((int)i).first;
        }
        i = 0;
        while (true) {
            block8: {
                AnAction actualAction;
                ActionStub stub;
                block9: {
                    block7: {
                        if (i >= children.length) break block7;
                        AnAction action = children[i];
                        if (!(action instanceof ActionStub)) break block8;
                        stub = (ActionStub)action;
                        ActionManager actionManager = e != null ? e.getActionManager() : ActionManager.getInstance();
                        actualAction = actionManager.getAction(stub.getId());
                        int index = this.mySortedChildren.indexOf(stub);
                        if (index == -1) break block9;
                        children[i] = actualAction;
                        this.mySortedChildren.set(index, actualAction);
                        break block8;
                    }
                    if (children == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/openapi/actionSystem/DefaultActionGroup.getChildren must not return null");
                    }
                    return children;
                }
                int j = 0;
                while (true) {
                    if (j >= this.myPairs.size()) {
                        throw new IllegalStateException("unknown stub: " + stub.getId());
                    }
                    Pair<AnAction, Constraints> pair = this.myPairs.get(j);
                    if (((AnAction)pair.first).equals(stub)) {
                        children[i] = actualAction;
                        this.myPairs.set(j, new Pair(actualAction, pair.second));
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public final int getChildrenCount() {
        return this.mySortedChildren.size() + this.myPairs.size();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final AnAction[] getChildActionsOrStubs(@Nullable AnActionEvent e) {
        int i;
        int sortedSize = this.mySortedChildren.size();
        AnAction[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i = 0; i < sortedSize; ++i) {
            children[i] = this.mySortedChildren.get(i);
        }
        for (i = 0; i < this.myPairs.size(); ++i) {
            children[i + sortedSize] = (AnAction)this.myPairs.get((int)i).first;
        }
        if (children == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/actionSystem/DefaultActionGroup.getChildActionsOrStubs must not return null");
        }
        return children;
    }

    public final void addAll(ActionGroup group) {
        for (AnAction each : group.getChildren(null)) {
            this.add(each);
        }
    }
}

