/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataKey<T> {
    private static final Map<String, DataKey> ourDataKeyIndex = new HashMap<String, DataKey>();
    private final String myName;

    private DataKey(String name) {
        this.myName = name;
    }

    public static <T> DataKey<T> create(@NonNls String name) {
        if (ourDataKeyIndex.containsKey(name)) {
            return ourDataKeyIndex.get(name);
        }
        DataKey<T> key = new DataKey<T>(name);
        ourDataKeyIndex.put(name, key);
        return key;
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public T getData(DataContext dataContext) {
        return (T)dataContext.getData(this.myName);
    }
}

