/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.InputEvent;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnActionEvent {
    private final InputEvent myInputEvent;
    private final ActionManager myActionManager;
    @NotNull
    private final DataContext myDataContext;
    @NotNull
    private final String myPlace;
    @NotNull
    private final Presentation myPresentation;
    private final int myModifiers;
    private boolean myWorksInInjected;
    @NonNls
    private static final String ourInjectedPrefix = "$injected$.";
    private static final Map<String, String> ourInjectedIds = new HashMap<String, String>();

    public AnActionEvent(InputEvent inputEvent, @NotNull DataContext dataContext, @NotNull @NonNls String place, @NotNull Presentation presentation, ActionManager actionManager, int modifiers) {
        if (dataContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/AnActionEvent.<init> must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/actionSystem/AnActionEvent.<init> must not be null");
        }
        if (presentation == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/actionSystem/AnActionEvent.<init> must not be null");
        }
        this.myInputEvent = inputEvent;
        this.myActionManager = actionManager;
        this.myDataContext = dataContext;
        this.myPlace = place;
        this.myPresentation = presentation;
        this.myModifiers = modifiers;
    }

    public InputEvent getInputEvent() {
        return this.myInputEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNls
    public static String injectedId(String dataId) {
        Map<String, String> map = ourInjectedIds;
        synchronized (map) {
            String injected = ourInjectedIds.get(dataId);
            if (injected == null) {
                injected = ourInjectedPrefix + dataId;
                ourInjectedIds.put(dataId, injected);
            }
            return injected;
        }
    }

    @NonNls
    public static String uninjectedId(String dataId) {
        return StringUtil.trimStart(dataId, ourInjectedPrefix);
    }

    @NotNull
    public DataContext getDataContext() {
        DataContext dataContext;
        if (!(!this.myWorksInInjected ? (dataContext = this.myDataContext) != null : (dataContext = new DataContext(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                Object injected = AnActionEvent.this.myDataContext.getData(AnActionEvent.injectedId(dataId));
                if (injected != null) {
                    return injected;
                }
                return AnActionEvent.this.myDataContext.getData(dataId);
            }
        }) != null)) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/actionSystem/AnActionEvent.getDataContext must not return null");
        }
        return dataContext;
    }

    @Nullable
    public <T> T getData(@NotNull DataKey<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/AnActionEvent.getData must not be null");
        }
        return key.getData(this.getDataContext());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getPlace() {
        String string = this.myPlace;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/actionSystem/AnActionEvent.getPlace must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Presentation getPresentation() {
        Presentation presentation = this.myPresentation;
        if (presentation == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/actionSystem/AnActionEvent.getPresentation must not return null");
        }
        return presentation;
    }

    public int getModifiers() {
        return this.myModifiers;
    }

    public ActionManager getActionManager() {
        return this.myActionManager;
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public boolean isInInjectedContext() {
        return this.myWorksInInjected;
    }
}

