/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AnAction {
    public static final AnAction[] EMPTY_ARRAY = new AnAction[0];
    @NonNls
    public static final String ourClientProperty = "AnAction.shortcutSet";
    private Presentation myTemplatePresentation;
    private ShortcutSet myShortcutSet = ourEmptyShortcutSet;
    private boolean myEnabledInModalContext = false;
    private static final ShortcutSet ourEmptyShortcutSet = new CustomShortcutSet(new Shortcut[0]);
    private boolean myIsDefaultIcon = true;
    private boolean myWorksInInjected;

    public AnAction() {
        this(null);
    }

    public AnAction(String text) {
        this(text, null, null);
    }

    public AnAction(String text, String description, Icon icon) {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(text);
        presentation.setDescription(description);
        presentation.setIcon(icon);
    }

    public final ShortcutSet getShortcutSet() {
        return this.myShortcutSet;
    }

    public final void registerCustomShortcutSet(ShortcutSet shortcutSet, JComponent component) {
        this.myShortcutSet = shortcutSet;
        if (component != null) {
            ArrayList<AnAction> actionList = (ArrayList<AnAction>)component.getClientProperty(ourClientProperty);
            if (actionList == null) {
                actionList = new ArrayList<AnAction>(1);
                component.putClientProperty(ourClientProperty, actionList);
            }
            if (!actionList.contains(this)) {
                actionList.add(this);
            }
        }
    }

    public final void unregisterCustomShortcutSet(JComponent component) {
        ArrayList actionList;
        if (component != null && (actionList = (ArrayList)component.getClientProperty(ourClientProperty)) != null) {
            actionList.remove(this);
        }
    }

    public final void copyFrom(@NotNull AnAction sourceAction) {
        if (sourceAction == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/AnAction.copyFrom must not be null");
        }
        Presentation sourcePresentation = sourceAction.getTemplatePresentation();
        Presentation presentation = this.getTemplatePresentation();
        presentation.setIcon(sourcePresentation.getIcon());
        presentation.setText(sourcePresentation.getTextWithMnemonic());
        presentation.setDescription(sourcePresentation.getDescription());
        this.copyShortcutFrom(sourceAction);
    }

    public final void copyShortcutFrom(AnAction sourceAction) {
        this.myShortcutSet = sourceAction.myShortcutSet;
    }

    public final boolean isEnabledInModalContext() {
        return this.myEnabledInModalContext;
    }

    protected final void setEnabledInModalContext(boolean enabledInModalContext) {
        this.myEnabledInModalContext = enabledInModalContext;
    }

    public boolean displayTextInToolbar() {
        return false;
    }

    public void update(AnActionEvent e) {
    }

    public void beforeActionPerformedUpdate(AnActionEvent e) {
        boolean worksInInjected = this.isInInjectedContext();
        e.setInjectedContext(worksInInjected);
        this.update(e);
        if (!e.getPresentation().isEnabled() && worksInInjected) {
            e.setInjectedContext(false);
            this.update(e);
        }
    }

    public final Presentation getTemplatePresentation() {
        if (this.myTemplatePresentation == null) {
            this.myTemplatePresentation = new Presentation();
        }
        return this.myTemplatePresentation;
    }

    public abstract void actionPerformed(AnActionEvent var1);

    protected void setShortcutSet(ShortcutSet shortcutSet) {
        this.myShortcutSet = shortcutSet;
    }

    public static String createTooltipText(String s, AnAction action) {
        String toolTipText;
        String string = toolTipText = s != null ? s : "";
        while (StringUtil.endsWithChar(toolTipText, '.')) {
            toolTipText = toolTipText.substring(0, toolTipText.length() - 1);
        }
        String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText(action);
        if (shortcutsText.length() > 0) {
            toolTipText = toolTipText + " (" + shortcutsText + ")";
        }
        return toolTipText;
    }

    public void setDefaultIcon(boolean isDefaultIconSet) {
        this.myIsDefaultIcon = isDefaultIconSet;
    }

    public boolean isDefaultIcon() {
        return this.myIsDefaultIcon;
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public boolean isInInjectedContext() {
        return this.myWorksInInjected;
    }
}

