/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import org.jetbrains.annotations.NotNull;

public class ActionStub
extends AnAction {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.actionSystem.ActionStub");
    private final String myClassName;
    private final String myId;
    private final String myText;
    private final ClassLoader myLoader;
    private final PluginId myPluginId;
    private final String myIconPath;

    public ActionStub(@NotNull String actionClass, @NotNull String id, @NotNull String text, ClassLoader loader, PluginId pluginId, String iconPath) {
        if (actionClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/ActionStub.<init> must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/ActionStub.<init> must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/actionSystem/ActionStub.<init> must not be null");
        }
        this.myLoader = loader;
        this.myClassName = actionClass;
        LOG.assertTrue(id.length() > 0);
        this.myId = id;
        this.myText = text;
        this.myPluginId = pluginId;
        this.myIconPath = iconPath;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public String getId() {
        return this.myId;
    }

    public String getText() {
        return this.myText;
    }

    public ClassLoader getLoader() {
        return this.myLoader;
    }

    public PluginId getPluginId() {
        return this.myPluginId;
    }

    public String getIconPath() {
        return this.myIconPath;
    }

    public void actionPerformed(AnActionEvent e) {
        throw new UnsupportedOperationException();
    }

    public final void initAction(@NotNull AnAction targetAction) {
        if (targetAction == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/ActionStub.initAction must not be null");
        }
        Presentation sourcePresentation = this.getTemplatePresentation();
        Presentation targetPresentation = targetAction.getTemplatePresentation();
        if (targetPresentation.getIcon() == null && sourcePresentation.getIcon() != null) {
            targetPresentation.setIcon(sourcePresentation.getIcon());
        }
        if (targetPresentation.getText() == null && sourcePresentation.getText() != null) {
            targetPresentation.setText(sourcePresentation.getText());
        }
        if (targetPresentation.getDescription() == null && sourcePresentation.getDescription() != null) {
            targetPresentation.setDescription(sourcePresentation.getDescription());
        }
        targetAction.setShortcutSet(this.getShortcutSet());
    }
}

