/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionGroupUtil {
    private static Presentation getPresentation(AnAction action, Map<AnAction, Presentation> action2presentation) {
        Presentation presentation = action2presentation.get(action);
        if (presentation == null) {
            presentation = (Presentation)action.getTemplatePresentation().clone();
            action2presentation.put(action, presentation);
        }
        return presentation;
    }

    public static boolean isGroupEmpty(ActionGroup actionGroup, AnActionEvent e) {
        return ActionGroupUtil.isGroupEmpty(actionGroup, e, new HashMap<AnAction, Presentation>());
    }

    private static boolean isGroupEmpty(ActionGroup actionGroup, AnActionEvent e, Map<AnAction, Presentation> action2presentation) {
        AnAction[] actions;
        for (AnAction action : actions = actionGroup.getChildren(e)) {
            if (action instanceof Separator || !(action instanceof ActionGroup ? ActionGroupUtil.isActionEnabledAndVisible(e, action2presentation, action) && !ActionGroupUtil.isGroupEmpty((ActionGroup)action, e, action2presentation) : ActionGroupUtil.isActionEnabledAndVisible(e, action2presentation, action))) continue;
            return false;
        }
        return true;
    }

    private static boolean isActionEnabledAndVisible(AnActionEvent e, Map<AnAction, Presentation> action2presentation, AnAction action) {
        Presentation presentation = ActionGroupUtil.getPresentation(action, action2presentation);
        AnActionEvent event = new AnActionEvent(e.getInputEvent(), e.getDataContext(), "unknown", presentation, ActionManager.getInstance(), e.getModifiers());
        event.setInjectedContext(action.isInInjectedContext());
        action.update(event);
        return presentation.isEnabled() && presentation.isVisible();
    }
}

