/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class ActionGroup
extends AnAction {
    private boolean myPopup;
    private PropertyChangeSupport myChangeSupport = new PropertyChangeSupport(this);
    @NonNls
    public static final String PROP_POPUP = "popup";

    public ActionGroup() {
        this(null, false);
    }

    public ActionGroup(String shortName, boolean popup) {
        super(shortName);
        this.setPopup(popup);
    }

    public final void actionPerformed(AnActionEvent e) {
    }

    public final boolean isPopup() {
        return this.myPopup;
    }

    public final void setPopup(boolean popup) {
        boolean oldPopup = this.myPopup;
        this.myPopup = popup;
        this.firePropertyChange(PROP_POPUP, oldPopup ? Boolean.TRUE : Boolean.FALSE, this.myPopup ? Boolean.TRUE : Boolean.FALSE);
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.removePropertyChangeListener(l);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.myChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public abstract AnAction[] getChildren(@Nullable AnActionEvent var1);
}

