/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.ui.ComponentTreeWatcher;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.DialogUtil;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import org.jetbrains.annotations.NonNls;

public class MnemonicHelper
extends ComponentTreeWatcher {
    public static final PropertyChangeListener TEXT_LISTENER = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof AbstractButton) {
                DialogUtil.registerMnemonic((AbstractButton)source);
            } else if (source instanceof JLabel) {
                DialogUtil.registerMnemonic((JLabel)source, null);
            }
        }
    };
    @NonNls
    public static final String TEXT_CHANGED_PROPERTY = "text";

    public MnemonicHelper() {
        super(ArrayUtil.EMPTY_CLASS_ARRAY);
    }

    protected void processComponent(Component parentComponent) {
        if (parentComponent instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)parentComponent;
            abstractButton.addPropertyChangeListener(TEXT_CHANGED_PROPERTY, TEXT_LISTENER);
            DialogUtil.registerMnemonic(abstractButton);
        } else if (parentComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)parentComponent;
            jLabel.addPropertyChangeListener(TEXT_CHANGED_PROPERTY, TEXT_LISTENER);
            DialogUtil.registerMnemonic(jLabel, null);
        }
    }

    protected void unprocessComponent(Component component) {
    }
}

