/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;

public class StoppableLexerAdapter
implements Lexer {
    private Lexer myOriginal;
    private StoppingCondition myCondition;
    private boolean myStopped = false;

    public Lexer getOriginal() {
        return this.myOriginal;
    }

    public StoppableLexerAdapter(StoppingCondition condition, Lexer original) {
        this.myCondition = condition;
        this.myOriginal = original;
        this.myStopped = this.myCondition.stopsAt(this.myOriginal.getTokenType(), this.myOriginal.getTokenStart(), this.myOriginal.getTokenEnd());
    }

    public void advance() {
        if (this.myStopped) {
            return;
        }
        this.myOriginal.advance();
        if (this.myCondition.stopsAt(this.myOriginal.getTokenType(), this.myOriginal.getTokenStart(), this.myOriginal.getTokenEnd())) {
            this.myStopped = true;
        }
    }

    public int getPrevTokenEnd() {
        return this.myOriginal instanceof StoppableLexerAdapter ? ((StoppableLexerAdapter)this.myOriginal).getPrevTokenEnd() : ((FilterLexer)this.myOriginal).getPrevTokenEnd();
    }

    public char[] getBuffer() {
        return this.myOriginal.getBuffer();
    }

    public int getBufferEnd() {
        return this.myOriginal.getBufferEnd();
    }

    public LexerPosition getCurrentPosition() {
        return this.myOriginal.getCurrentPosition();
    }

    public int getState() {
        return this.myOriginal.getState();
    }

    public int getTokenEnd() {
        return this.myStopped ? this.myOriginal.getTokenStart() : this.myOriginal.getTokenEnd();
    }

    public int getTokenStart() {
        return this.myOriginal.getTokenStart();
    }

    public IElementType getTokenType() {
        return this.myStopped ? null : this.myOriginal.getTokenType();
    }

    public void restore(LexerPosition position) {
        this.myOriginal.restore(position);
    }

    public void start(char[] buffer) {
        this.myOriginal.start(buffer);
    }

    public void start(char[] buffer, int startOffset, int endOffset) {
        this.myOriginal.start(buffer, startOffset, endOffset);
    }

    public void start(char[] buffer, int startOffset, int endOffset, int initialState) {
        this.myOriginal.start(buffer, startOffset, endOffset, initialState);
    }

    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myOriginal.start(buffer, startOffset, endOffset, initialState);
    }

    public CharSequence getBufferSequence() {
        return this.myOriginal.getBufferSequence();
    }

    public static interface StoppingCondition {
        public boolean stopsAt(IElementType var1, int var2, int var3);
    }
}

