/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LexerState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class MergingLexerAdapter
extends LexerBase {
    private Lexer myOriginal;
    private TokenSet myTokensToMerge;
    private IElementType myTokenType;
    private int myState;
    private int myTokenStart;

    public MergingLexerAdapter(Lexer original, TokenSet tokensToMerge) {
        this.myOriginal = original;
        this.myTokensToMerge = tokensToMerge;
    }

    public void start(char[] buffer, int startOffset, int endOffset, int initialState) {
        this.myOriginal.start(buffer, startOffset, endOffset, initialState);
        this.myTokenType = null;
    }

    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myOriginal.start(buffer, startOffset, endOffset, initialState);
        this.myTokenType = null;
    }

    public CharSequence getBufferSequence() {
        return this.myOriginal.getBufferSequence();
    }

    public int getState() {
        this.locateToken();
        return this.myState;
    }

    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public int getTokenStart() {
        this.locateToken();
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        this.locateToken();
        return this.myOriginal.getTokenStart();
    }

    public void advance() {
        this.myTokenType = null;
    }

    public char[] getBuffer() {
        return this.myOriginal.getBuffer();
    }

    public int getBufferEnd() {
        return this.myOriginal.getBufferEnd();
    }

    private void locateToken() {
        if (this.myTokenType == null) {
            this.myTokenType = this.myOriginal.getTokenType();
            this.myTokenStart = this.myOriginal.getTokenStart();
            this.myState = this.myOriginal.getState();
            if (this.myTokenType == null) {
                return;
            }
            this.myOriginal.advance();
            if (this.myTokensToMerge.contains(this.myTokenType)) {
                IElementType tokenType;
                while ((tokenType = this.myOriginal.getTokenType()) == this.myTokenType) {
                    this.myOriginal.advance();
                }
            }
        }
    }

    public Lexer getOriginal() {
        return this.myOriginal;
    }

    public void restore(LexerPosition position) {
        MyLexerPosition pos = (MyLexerPosition)position;
        this.myOriginal.restore(pos.getOriginalPosition());
        this.myTokenType = pos.getType();
        this.myTokenStart = pos.getOffset();
        this.myState = pos.getOldState();
    }

    public LexerPosition getCurrentPosition() {
        return new MyLexerPosition(this.myTokenStart, this.myTokenType, this.myOriginal.getCurrentPosition(), this.myState);
    }

    private static class MyLexerPosition
    implements LexerPosition {
        private int myOffset;
        private IElementType myTokenType;
        private LexerPosition myOriginalPosition;
        private int myOldState;

        public MyLexerPosition(int offset, IElementType tokenType, LexerPosition originalPosition, int oldState) {
            this.myOffset = offset;
            this.myTokenType = tokenType;
            this.myOriginalPosition = originalPosition;
            this.myOldState = oldState;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public LexerState getState() {
            return this.myOriginalPosition.getState();
        }

        public IElementType getType() {
            return this.myTokenType;
        }

        public LexerPosition getOriginalPosition() {
            return this.myOriginalPosition;
        }

        public int getOldState() {
            return this.myOldState;
        }
    }
}

