/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LexerPositionImpl;
import com.intellij.lexer.SimpleLexerState;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;

public abstract class LexerBase
implements Lexer {
    public LexerPosition getCurrentPosition() {
        int offset = this.getTokenStart();
        int intState = this.getState();
        SimpleLexerState state = new SimpleLexerState(intState);
        return new LexerPositionImpl(offset, state);
    }

    public void restore(LexerPosition position) {
        this.start(this.getBufferSequence(), position.getOffset(), this.getBufferEnd(), ((SimpleLexerState)position.getState()).getState());
    }

    public CharSequence getBufferSequence() {
        return new CharArrayCharSequence(this.getBuffer());
    }

    public void start(char[] buffer) {
        this.start(buffer, 0, buffer.length);
    }

    public void start(char[] buffer, int startOffset, int endOffset) {
        this.start(buffer, startOffset, endOffset, 0);
    }

    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.start(CharArrayUtil.fromSequence(buffer), startOffset, endOffset, initialState);
    }
}

