/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LexerPositionImpl;
import com.intellij.lexer.SimpleLexerState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.HashMap;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashSet;
import java.util.Map;

public class LayeredLexer
extends LexerBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.lexer.LayeredLexer");
    private static final int IN_LAYER_STATE = 1024;
    private CharSequence myBuffer;
    private int myBufferEnd;
    private int myState;
    private Lexer myBaseLexer;
    private Map<IElementType, Lexer> myStartTokenToLayerLexer = new HashMap<IElementType, Lexer>();
    private Lexer myCurrentLayerLexer;
    private HashSet<Lexer> mySelfStoppingLexers = new HashSet(1);
    private HashMap<Lexer, IElementType[]> myStopTokens = new HashMap(1);

    public LayeredLexer(Lexer baseLexer) {
        this.myBaseLexer = baseLexer;
    }

    public void registerSelfStoppingLayer(Lexer Lexer2, IElementType[] startTokens, IElementType[] stopTokens) {
        this.registerLayer(Lexer2, startTokens);
        this.mySelfStoppingLexers.add(Lexer2);
        this.myStopTokens.put(Lexer2, stopTokens);
    }

    public void registerLayer(Lexer Lexer2, IElementType ... startTokens) {
        for (IElementType startToken : startTokens) {
            LOG.assertTrue(!this.myStartTokenToLayerLexer.containsKey(startToken));
            this.myStartTokenToLayerLexer.put(startToken, Lexer2);
        }
    }

    private void activateLayerIfNecessary() {
        this.myCurrentLayerLexer = this.myStartTokenToLayerLexer.get(this.myBaseLexer.getTokenType());
        if (this.myCurrentLayerLexer != null) {
            this.myCurrentLayerLexer.start(this.myBaseLexer.getBufferSequence(), this.myBaseLexer.getTokenStart(), this.myBaseLexer.getTokenEnd(), 0);
            if (this.mySelfStoppingLexers.contains(this.myCurrentLayerLexer)) {
                this.myBaseLexer.advance();
            }
        }
    }

    public void start(char[] buffer, int startOffset, int endOffset, int initialState) {
        this.start(new CharArrayCharSequence(buffer), startOffset, endOffset, initialState);
    }

    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        LOG.assertTrue(initialState != 1024, "Restoring to layer is not supported.");
        this.myState = initialState;
        this.myCurrentLayerLexer = null;
        this.myBuffer = buffer;
        this.myBufferEnd = endOffset;
        this.myBaseLexer.start(buffer, startOffset, endOffset, initialState);
        this.activateLayerIfNecessary();
    }

    public int getState() {
        return this.myState;
    }

    public IElementType getTokenType() {
        return this.isLayerActive() ? this.myCurrentLayerLexer.getTokenType() : this.myBaseLexer.getTokenType();
    }

    public int getTokenStart() {
        return this.isLayerActive() ? this.myCurrentLayerLexer.getTokenStart() : this.myBaseLexer.getTokenStart();
    }

    public int getTokenEnd() {
        return this.isLayerActive() ? this.myCurrentLayerLexer.getTokenEnd() : this.myBaseLexer.getTokenEnd();
    }

    public void advance() {
        if (this.isLayerActive()) {
            IElementType layerTokenType = this.myCurrentLayerLexer.getTokenType();
            if (!this.isStopToken(this.myCurrentLayerLexer, layerTokenType)) {
                this.myCurrentLayerLexer.advance();
                layerTokenType = this.myCurrentLayerLexer.getTokenType();
            } else {
                layerTokenType = null;
            }
            if (layerTokenType == null) {
                int tokenEnd = this.myCurrentLayerLexer.getTokenEnd();
                if (!this.mySelfStoppingLexers.contains(this.myCurrentLayerLexer)) {
                    this.myCurrentLayerLexer = null;
                    this.myBaseLexer.advance();
                    this.activateLayerIfNecessary();
                } else {
                    this.myCurrentLayerLexer = null;
                }
            }
        } else {
            this.myBaseLexer.advance();
            this.activateLayerIfNecessary();
        }
        this.myState = this.isLayerActive() ? 1024 : this.myBaseLexer.getState();
    }

    public LexerPosition getCurrentPosition() {
        int offset = this.getTokenStart();
        int intState = this.getState();
        SimpleLexerState state = new SimpleLexerState(intState);
        return new LexerPositionImpl(offset, state);
    }

    public void restore(LexerPosition position) {
        this.start(this.getBufferSequence(), position.getOffset(), this.getBufferEnd(), ((SimpleLexerState)position.getState()).getState());
    }

    private boolean isStopToken(Lexer lexer, IElementType tokenType) {
        IElementType[] stopTokens = (IElementType[])this.myStopTokens.get(lexer);
        if (stopTokens == null) {
            return false;
        }
        for (IElementType stopToken : stopTokens) {
            if (stopToken != tokenType) continue;
            return true;
        }
        return false;
    }

    public char[] getBuffer() {
        return CharArrayUtil.fromSequence(this.myBuffer);
    }

    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    private boolean isLayerActive() {
        return this.myCurrentLayerLexer != null;
    }

    public Lexer getBaseLexer() {
        return this.myBaseLexer;
    }
}

